/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.edition;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.ArrayList;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.TypoOptions;

public class SectionParserCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SectionParser";
    public static final String TEXT_PARAMNAME = "text";
    private Corpus corpus;
    private String text;

    public SectionParserCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheBlocks ficheBlocks = this.toFicheBlocks();
        this.putResultObject("obj.corpus", this.corpus);
        this.putResultObject("obj.ficheblocks", ficheBlocks);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.text = this.getMandatory(TEXT_PARAMNAME);
    }

    private FicheBlocks toFicheBlocks() {
        if (this.text.isEmpty()) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        TypoOptions typoOptions = BdfUserUtils.getTypoOptions(this.bdfUser);
        FicheBlockParser ficheBlockParser = new FicheBlockParser(this.bdfServer.getHtmlCleaner(), typoOptions, true);
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        ficheBlockParser.parseFicheBlockList(this.text, list);
        return FicheUtils.toFicheBlocks(list);
    }
}

