/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.xml;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import net.desmodo.simplegrille.api.SimpleAtlas;
import net.desmodo.simplegrille.api.SimpleContexte;
import net.desmodo.simplegrille.api.SimpleContexteList;
import net.desmodo.simplegrille.api.SimpleDescripteurFils;
import net.desmodo.simplegrille.api.SimpleDescripteurFilsList;
import net.desmodo.simplegrille.api.SimpleDescripteurPere;
import net.desmodo.simplegrille.api.SimpleFamille;
import net.desmodo.simplegrille.api.SimpleStructure;
import net.mapeadores.util.awt.ColorUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.xml.DefaultXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class SimpleGrilleXMLWriter
extends DefaultXMLWriter {
    public void appendSimpleGrille(SimpleAtlas simpleAtlas) throws IOException {
        this.appendSimpleGrille(simpleAtlas, null, true);
    }

    public void appendSimpleGrille(String newPrefixe, SimpleAtlas simpleAtlas) throws IOException {
        this.appendSimpleGrille(simpleAtlas, newPrefixe, false);
    }

    private void appendSimpleGrille(SimpleAtlas simpleAtlas, String newPrefixe, boolean withDescripteursFils) throws IOException {
        this.openTag("simple-grille");
        if (newPrefixe == null || newPrefixe.length() == 0) {
            newPrefixe = simpleAtlas.getPrefixe();
        }
        this.appendPrefixe(newPrefixe);
        XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleAtlas.getLabels());
        this.appendUiPattern(simpleAtlas.getUiPatternString());
        this.appendSimpleStructure(simpleAtlas.getSimpleStructure());
        if (withDescripteursFils) {
            this.appendDescripteurFilsList(simpleAtlas.getAutoIncrement(), simpleAtlas.getSimpleDescripteurFilsList());
        }
        this.closeTag("simple-grille");
    }

    public void appendSimpleGrilleCompil(Collection<SimpleAtlas> simpleAtlasCollection, SimpleStructure simpleStructure) throws IOException {
        this.openTag("simple-grille-compil");
        boolean premier = true;
        if (simpleStructure != null) {
            premier = false;
            this.appendSimpleStructure(simpleStructure);
        }
        for (SimpleAtlas simpleAtlas : simpleAtlasCollection) {
            if (premier) {
                premier = false;
                this.appendSimpleStructure(simpleAtlas.getSimpleStructure());
            }
            this.openTag("simple-atlas");
            this.appendPrefixe(simpleAtlas.getPrefixe());
            XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleAtlas.getLabels());
            this.appendDescripteurFilsList(simpleAtlas.getAutoIncrement(), simpleAtlas.getSimpleDescripteurFilsList());
            this.closeTag("simple-atlas");
        }
        this.closeTag("simple-grille-compil");
    }

    private void appendPrefixe(String prefixe) throws IOException {
        this.addSimpleElement("prefixe", prefixe);
    }

    private void appendUiPattern(String uiPatternString) throws IOException {
        if (uiPatternString != null) {
            this.addSimpleElement("ui-pattern", uiPatternString);
        }
    }

    public void appendSimpleStructure(SimpleStructure simpleStructure) throws IOException {
        this.openTag("simple-structure");
        this.openTag("langs");
        for (Lang lang : simpleStructure.getLangs()) {
            this.addSimpleElement("lang", lang.toString());
        }
        this.closeTag("langs");
        int listCount = simpleStructure.getSimpleContexteListCount();
        for (int i = 0; i < listCount; ++i) {
            this.appendSimpleContexteList(simpleStructure.getSimpleContexteList(i));
        }
        int familleCount = simpleStructure.getSimpleFamilleCount();
        if (familleCount > 0) {
            this.openTag("simple-famille-list");
            for (int i = 0; i < familleCount; ++i) {
                SimpleFamille simpleFamille = simpleStructure.getSimpleFamille(i);
                this.startOpenTag("simple-famille");
                this.addAttribute("idfamille", simpleFamille.getIdfamille());
                Color color = simpleFamille.getColor();
                if (color != null) {
                    this.addAttribute("color", ColorUtils.toHexFormat((Color)color));
                }
                this.endOpenTag();
                XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleFamille.getLabels());
                this.closeTag("simple-famille");
            }
            this.closeTag("simple-famille-list");
        }
        this.openTag("simple-descripteur-pere-list");
        int descripteurCount = simpleStructure.getSimpleDescripteurPereCount();
        for (int i = 0; i < descripteurCount; ++i) {
            SimpleDescripteurPere simpleDescripteur = simpleStructure.getSimpleDescripteurPere(i);
            SimpleContexteList simpleContexteList = simpleDescripteur.getSimpleContexteList();
            this.startOpenTag("simple-descripteur-pere");
            this.addAttribute("iddesc", simpleDescripteur.getIddesc());
            SimpleFamille simpleFamille = simpleDescripteur.getSimpleFamille();
            if (simpleFamille != null) {
                this.addAttribute("idfamille", simpleFamille.getIdfamille());
            }
            this.addAttribute("contexte-list-name", simpleContexteList.getName());
            this.endOpenTag();
            if (simpleDescripteur.hasExpectedFilsCount()) {
                int ct = simpleContexteList.getSimpleContexteCount();
                for (int j = 0; j < ct; ++j) {
                    SimpleContexte simpleContexte = simpleContexteList.getSimpleContexte(j);
                    int itg = simpleDescripteur.getExpectedFilsCount(simpleContexte);
                    if (itg <= 0) continue;
                    this.startOpenTag("fils-list-length");
                    this.addAttribute("idctxt", simpleContexte.getIdctxt());
                    this.addAttribute("value", itg);
                    this.closeEmptyTag();
                }
            }
            XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleDescripteur.getLabels());
            this.closeTag("simple-descripteur-pere");
        }
        this.closeTag("simple-descripteur-pere-list");
        this.closeTag("simple-structure");
    }

    private void appendSimpleContexteList(SimpleContexteList simpleContexteListe) throws IOException {
        this.startOpenTag("simple-contexte-list");
        this.addAttribute("name", simpleContexteListe.getName());
        Color listColor = simpleContexteListe.getColor();
        if (listColor != null) {
            this.addAttribute("color", ColorUtils.toHexFormat((Color)listColor));
        }
        this.endOpenTag();
        XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleContexteListe.getLabels());
        int contexteCount = simpleContexteListe.getSimpleContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            SimpleContexte simpleContexte = simpleContexteListe.getSimpleContexte(i);
            this.startOpenTag("simple-contexte");
            this.addAttribute("idctxt", simpleContexte.getIdctxt());
            Color color = simpleContexte.getColor();
            if (color != null) {
                this.addAttribute("color", ColorUtils.toHexFormat((Color)color));
            }
            this.endOpenTag();
            XMLUtils.addLibElements((XMLWriter)this, (Labels)simpleContexte.getLabels());
            this.closeTag("simple-contexte");
        }
        this.closeTag("simple-contexte-list");
    }

    public void appendDescripteurFilsList(int autoIncrement, SimpleDescripteurFilsList list) throws IOException {
        int count = list.getSimpleDescripteurFilsCount();
        if (count == 0) {
            return;
        }
        this.startOpenTag("simple-descripteur-fils-list");
        this.addAttribute("auto-increment", autoIncrement);
        this.endOpenTag();
        for (int i = 0; i < count; ++i) {
            SimpleDescripteurFils sdf = list.getSimpleDescripteurFils(i);
            this.startOpenTag("simple-descripteur-fils");
            this.addAttribute("iddesc", sdf.getIddesc());
            SimpleDescripteurPere sdp = sdf.getSimpleDescripteurPere();
            this.addAttribute("pere-iddesc", sdp.getIddesc());
            SimpleContexte contexte = sdf.getSimpleContexte();
            this.addAttribute("idctxt", contexte.getIdctxt());
            this.endOpenTag();
            XMLUtils.addLibElements((XMLWriter)this, (Labels)sdf.getLabels());
            this.closeTag("simple-descripteur-fils");
        }
        this.closeTag("simple-descripteur-fils-list");
    }
}

