/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen.writers;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import java.io.IOException;
import net.fichotheque.alias.AliasHolder;
import net.mapeadores.util.money.MoneyLong;

public class SageComptagenWriter
implements ComptagenWriter {
    private final Appendable appendable;
    private final AliasHolder coreAliasHolder;
    private final int maxLength = 40;
    private final int exportFractionDigits;

    public SageComptagenWriter(Appendable appendable, AliasHolder coreAliasHolder, int exportFractionDigits) {
        this.appendable = appendable;
        this.coreAliasHolder = coreAliasHolder;
        this.exportFractionDigits = exportFractionDigits;
    }

    @Override
    public String getCharset() {
        return "windows-1252";
    }

    @Override
    public String getExtension() {
        return ".txt";
    }

    @Override
    public void writeLigne(ComptagenLigne ligne) throws IOException {
        String contrepartieLettre;
        String compteLettre;
        String modePaiement = ligne.getModePaiement();
        int numerocheque = ligne.getNumerocheque();
        if (numerocheque > -1) {
            modePaiement = modePaiement + " N\u00b0" + numerocheque;
        }
        String date = ligne.getDate().toString();
        String journal = ligne.getJournal().getCode();
        String piece = ligne.getPieceRef();
        String libelle = ComptagenUtils.getShortTitle(ligne, 40);
        String montant = MoneyLong.toString((long)ligne.getExportMoneyLong(), (int)this.exportFractionDigits);
        String facture = ligne.getFacture();
        if (ligne.isDebit()) {
            compteLettre = "D";
            contrepartieLettre = "C";
        } else {
            compteLettre = "C";
            contrepartieLettre = "D";
        }
        this.first(journal);
        this.next(date);
        this.next(ligne.getNumeroCompte());
        this.next(ligne.getNumeroCompteTiers());
        this.next(piece);
        this.next(libelle);
        this.next(montant);
        this.next(compteLettre);
        this.next(modePaiement);
        this.next(facture);
        this.appendable.append("\r\n");
        String contrepartie = ligne.getNumeroContrepartie();
        if (contrepartie.length() > 0) {
            this.first(journal);
            this.next(date);
            this.next(ligne.getNumeroContrepartie());
            this.next("");
            this.next(piece);
            this.next(libelle);
            this.next(montant);
            this.next(contrepartieLettre);
            this.next(modePaiement);
            this.next(facture);
            this.appendable.append("\r\n");
        }
    }

    private void first(String s) throws IOException {
        this.appendable.append(s);
    }

    private void next(String s) throws IOException {
        this.appendable.append('\t');
        this.appendable.append(s);
    }
}

