/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.detail;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetail;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItemEligibility;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueDetailBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueDetailsBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.EngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.detail.ConversionDetailEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.detail.NaturalDetailEngine;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.date.RangeDateFilter;
import net.mapeadores.util.money.Currencies;

public abstract class DetailEngine {
    private AnalytiqueParameters analytiqueParameters;
    private RangeDateFilter dateFilter;
    private Predicate<FicheMeta> lignePredicate;
    private boolean withRecap;

    protected DetailEngine() {
    }

    public abstract MoneyByCurrency toMoneyByCurrency(Ligne var1);

    public abstract MoneyByCurrency toMoneyByCurrency(Avenir var1);

    public abstract MutableMoneyByCurrency getMutableMoneyByCurrency();

    public abstract Currencies getCustomCurrencies();

    public AnalytiqueDetails buildFromAnalytiqueItem(AnalytiqueItem analytiqueItem) {
        AnalytiqueItemEligibility rootEligibility = AnalytiqueUtils.buildAnalytiqueItemEligibility(this.analytiqueParameters);
        int use = AnalytiqueUtils.useOwnLignes(this.analytiqueParameters.getAnalytiqueSubset(), analytiqueItem, rootEligibility);
        if (use == -1) {
            return null;
        }
        return AnalytiqueDetailsBuilder.init(this.analytiqueParameters, this.dateFilter, this.getCustomCurrencies(), analytiqueItem).addAnalytiqueDetail(this.buildDetail(analytiqueItem, rootEligibility, use == 1)).toAnalytiqueDetails();
    }

    public AnalytiqueDetails buildFromRoot() {
        AnalytiqueItemEligibility rootEligibility = AnalytiqueUtils.buildAnalytiqueItemEligibility(this.analytiqueParameters);
        AnalytiqueDetailsBuilder builder = new AnalytiqueDetailsBuilder(this.analytiqueParameters, this.dateFilter, this.getCustomCurrencies());
        for (AnalytiqueItem analytiqueItem : this.analytiqueParameters.getAnalytiqueSubset().getFirstLevelList()) {
            AnalytiqueDetail analytiqueDetail;
            int use = AnalytiqueUtils.useOwnLignes(this.analytiqueParameters.getAnalytiqueSubset(), analytiqueItem, rootEligibility);
            if (use == -1 || (analytiqueDetail = this.buildDetail(analytiqueItem, rootEligibility, use == 1)).isAvenirEmpty() && analytiqueDetail.isLigneEmpty()) continue;
            builder.addAnalytiqueDetail(analytiqueDetail);
        }
        return builder.toAnalytiqueDetails();
    }

    private AnalytiqueDetail buildDetail(AnalytiqueItem analytiqueItem, AnalytiqueItemEligibility currentEligibility, boolean selfInclude) {
        AnalytiqueDetailBuilder builder = new AnalytiqueDetailBuilder(analytiqueItem);
        if (selfInclude) {
            currentEligibility = currentEligibility.getChildrenDerivation();
            this.populate(builder, analytiqueItem);
            for (AnalytiqueGathering.SubCorpus subCorpus : analytiqueItem.getSubCorpusList()) {
                AnalytiqueDetailBuilder subCorpusBuilder = new AnalytiqueDetailBuilder(subCorpus);
                this.populate(subCorpusBuilder, subCorpus);
                builder.addSubDetail(subCorpusBuilder.toAnalytiqueDetail());
            }
            for (AnalytiqueGathering.Groupby groupby : analytiqueItem.getGroupbyList()) {
                builder.addSubDetail(this.buildGroupby(groupby));
            }
        }
        for (AnalytiqueItem child : analytiqueItem.getChildList()) {
            short test = currentEligibility.accept(child);
            if (test == 1) continue;
            boolean childSelfInclude = test == 3;
            builder.addSubDetail(this.buildDetail(child, currentEligibility, childSelfInclude));
        }
        return builder.toAnalytiqueDetail();
    }

    private AnalytiqueDetail buildGroupby(AnalytiqueGathering.Groupby groupby) {
        AnalytiqueDetailBuilder builder = new AnalytiqueDetailBuilder(groupby);
        for (AnalytiqueGathering.Groupby child : groupby.getChildList()) {
            builder.addSubDetail(this.buildGroupby(child));
        }
        this.populate(builder, groupby);
        return builder.toAnalytiqueDetail();
    }

    public static DetailEngine newDetailEngine(EngineParameters detailParameters, AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Predicate<FicheMeta> lignePredicate) {
        DetailEngine detailEngine;
        if (detailParameters instanceof NaturalEngineParameters) {
            detailEngine = new NaturalDetailEngine((NaturalEngineParameters)detailParameters);
        } else if (detailParameters instanceof ConversionEngineParameters) {
            detailEngine = new ConversionDetailEngine((ConversionEngineParameters)detailParameters);
        } else {
            throw new IllegalArgumentException("Unknown class: " + detailParameters.getClass().getName());
        }
        detailEngine.analytiqueParameters = analytiqueParameters;
        detailEngine.dateFilter = dateFilter;
        detailEngine.lignePredicate = lignePredicate;
        detailEngine.withRecap = analytiqueParameters.isDetailWithRecap();
        return detailEngine;
    }

    private void populate(AnalytiqueDetailBuilder builder, AnalytiqueGathering analytiqueItem) {
        MutableMoneyByCurrency avenirBeforeStart;
        MutableMoneyByCurrency lignesBeforeStart;
        if (this.withRecap) {
            lignesBeforeStart = this.getMutableMoneyByCurrency();
            avenirBeforeStart = this.getMutableMoneyByCurrency();
        } else {
            lignesBeforeStart = null;
            avenirBeforeStart = null;
        }
        this.testLigneList(builder, analytiqueItem.getApportList(), lignesBeforeStart);
        this.testLigneList(builder, analytiqueItem.getDepenseList(), lignesBeforeStart);
        this.testLigneList(builder, analytiqueItem.getAvanceList(), lignesBeforeStart);
        this.testLigneList(builder, analytiqueItem.getSoldeAvanceList(), lignesBeforeStart);
        this.testAvenirList(builder, analytiqueItem.getDepenseAvenirList(), avenirBeforeStart);
        if (this.withRecap) {
            builder.setLignesBeforeStart(lignesBeforeStart.toUnmodifiableMoneyByCurrency()).setAvenirBeforeStart(avenirBeforeStart.toUnmodifiableMoneyByCurrency());
        }
    }

    private void testLigneList(AnalytiqueDetailBuilder builder, List<Ligne> ligneList, MutableMoneyByCurrency lignesBeforeStart) {
        for (Ligne ligne : ligneList) {
            boolean beforeStart = false;
            if (this.dateFilter != null) {
                int test = this.dateFilter.testInRange(ligne.getDate());
                if (test == -1) {
                    if (lignesBeforeStart == null) continue;
                    beforeStart = true;
                } else if (test == 1) continue;
            }
            if (this.lignePredicate != null && !this.lignePredicate.test(ligne.getFicheMeta())) continue;
            MoneyByCurrency ligneMoneyByCurrency = this.toMoneyByCurrency(ligne);
            if (beforeStart) {
                lignesBeforeStart.add(ligneMoneyByCurrency);
                continue;
            }
            builder.addLigneDetail(AnalytiqueUtils.toLigneDetail(ligne, ligneMoneyByCurrency));
        }
    }

    private void testAvenirList(AnalytiqueDetailBuilder builder, List<Avenir> avenirList, MutableMoneyByCurrency avenirBeforeStart) {
        for (Avenir avenir : avenirList) {
            boolean beforeStart = false;
            if (this.dateFilter != null) {
                int test = this.dateFilter.testInRange(avenir.getDatePrevue());
                if (test == -1) {
                    if (avenirBeforeStart == null) continue;
                    beforeStart = true;
                } else if (test == 1) continue;
            }
            if (this.lignePredicate != null && !this.lignePredicate.test(avenir.getFicheMeta())) continue;
            MoneyByCurrency ligneMoneyByCurrency = this.toMoneyByCurrency(avenir);
            if (beforeStart) {
                avenirBeforeStart.add(ligneMoneyByCurrency);
                continue;
            }
            builder.addAvenirDetail(AnalytiqueUtils.toAvenirDetail(avenir, ligneMoneyByCurrency));
        }
    }
}

