/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.htmlpages;

import fr.exemole.bdfext.icyce.IcyceUtils;
import fr.exemole.bdfext.icyce.htmlpages.CadreHtmlPage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.localisation.Lang;

public class SpherePage
extends CadreHtmlPage {
    private Sphere sphere;
    private boolean maSphere = false;

    private SpherePage(BdfServer bdfServer, BdfUser bdfUser) {
        super(bdfServer, bdfUser);
    }

    private boolean initSphere(String param) {
        if (param == null) {
            this.maSphere = true;
            this.sphere = this.bdfUser.getRedacteur().getSphere();
            return true;
        }
        try {
            SubsetKey sphereKey = SubsetKey.parse((short)3, (String)param);
            Sphere sph = (Sphere)this.fichotheque.getSubset(sphereKey);
            if (sph == null) {
                return false;
            }
            this.sphere = sph;
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    @Override
    public String getTitle() {
        return FichothequeUtils.getTitle((Subset)this.sphere, (Lang)this.workingLang);
    }

    @Override
    public void addSupplementaryCss() {
    }

    @Override
    public void addSupplementaryJs() {
        this.addRscJs("icyce.js");
    }

    @Override
    public String getCurrentPage() {
        if (this.maSphere) {
            return "sphere.html";
        }
        return "sphere-" + this.sphere.getSubsetName() + ".html";
    }

    @Override
    public void printCorps() {
        this.H1();
        if (this.maSphere) {
            this.__localize("masphere").__escape((CharSequence)" : ");
        }
        this.__escape(FichothequeUtils.getTitle((Subset)this.sphere, (Lang)this.workingLang)).__dash().CODE().__escape('[').__escape((CharSequence)this.sphere.getSubsetName()).__escape(']')._CODE()._H1();
        this.printRedacteurs();
        this.H2().__localize("masphere_fiches")._H2();
        List<Corpus> corpusList = IcyceUtils.getCorpusList(this.fichotheque, "masphere");
        for (Corpus corpus : corpusList) {
            List<FicheMeta> list = this.geFicheMetaList(corpus);
            this.printCorpus(corpus, list, null, null, false);
        }
    }

    private List<FicheMeta> geFicheMetaList(Corpus corpus) {
        ArrayList<FicheMeta> list = new ArrayList<FicheMeta>();
        String sphereName = this.sphere.getSubsetName();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!ficheMeta.belongsToSphere(sphereName)) continue;
            list.add(ficheMeta);
        }
        return list;
    }

    private void printRedacteurs() {
        this.H2().__localize("masphere_redacteurs")._H2();
        this.UL();
        for (Redacteur redacteur : this.sphere.getRedacteurList()) {
            this.printRedacteur(redacteur);
        }
        this._UL();
    }

    private void printRedacteur(Redacteur redacteur) {
        this.LI().__escape((CharSequence)redacteur.getLogin()).__escape((CharSequence)" - ").__escape((CharSequence)redacteur.getCompleteName())._LI();
    }

    public static SpherePage newInstance(BdfServer bdfServer, BdfUser bdfUser, String param) {
        SpherePage spherePage = new SpherePage(bdfServer, bdfUser);
        boolean done = spherePage.initSphere(param);
        if (done) {
            return spherePage;
        }
        return null;
    }
}

