/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.json.producers;

import java.io.IOException;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.json.api.FieldFilter;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

public final class AtlasJsonUtils {
    private AtlasJsonUtils() {
    }

    public static void writeStructure(JSONWriter jsonWriter, Structure structure, FieldFilter fieldFilter) throws IOException {
        jsonWriter.key("structure");
        jsonWriter.object();
        jsonWriter.key("specialcontextes");
        jsonWriter.object();
        jsonWriter.key("horsgrille");
        AtlasJsonUtils.contexteObject(jsonWriter, structure.getSpecialContexte((short)5), fieldFilter, false);
        jsonWriter.key("sansfamille");
        AtlasJsonUtils.contexteObject(jsonWriter, structure.getSpecialContexte((short)6), fieldFilter, false);
        jsonWriter.endObject();
        jsonWriter.key("familles");
        AtlasJsonUtils.grilleObject(jsonWriter, structure.getGrilleDesFamilles(), fieldFilter, true);
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        if (grilleCount > 0) {
            jsonWriter.key("grilleArray");
            jsonWriter.array();
            for (int i = 0; i < grilleCount; ++i) {
                AtlasJsonUtils.grilleObject(jsonWriter, grilleList.getGrille(i), fieldFilter, true);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static void writeDescripteurs(JSONWriter jsonWriter, Descripteurs descripteurs, FieldFilter fieldFilter) throws IOException {
        DescripteurList sansfamilleDescripteurList;
        int descripteurCount;
        jsonWriter.key("descripteurs");
        jsonWriter.object();
        Structure structure = descripteurs.getAtlas().getStructure();
        ContexteList liste = StructureUtils.getContexteList(structure.getGrilleDesFamilles(), false);
        int contexteCount = liste.getContexteCount();
        if (contexteCount > 0) {
            jsonWriter.key("infamilleArray");
            jsonWriter.array();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte famille = liste.getContexte(i);
                DescripteurList infamilleDescripteurList = descripteurs.getInFamilleDescripteurList(famille);
                int descripteurCount2 = infamilleDescripteurList.getDescripteurCount();
                if (descripteurCount2 <= 0) continue;
                jsonWriter.object();
                jsonWriter.key("familleCode");
                jsonWriter.value((long)famille.getCode());
                jsonWriter.key("descripteurArray");
                jsonWriter.array();
                for (int j = 0; j < descripteurCount2; ++j) {
                    AtlasJsonUtils.descripteurObject(jsonWriter, infamilleDescripteurList.getDescripteur(j), fieldFilter);
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        if ((descripteurCount = (sansfamilleDescripteurList = descripteurs.getInFamilleDescripteurList(StructureUtils.getSansfamilleContexte(structure))).getDescripteurCount()) > 0) {
            jsonWriter.key("sansfamille");
            jsonWriter.object();
            jsonWriter.key("descripteurArray");
            jsonWriter.array();
            for (int i = 0; i < descripteurCount; ++i) {
                AtlasJsonUtils.descripteurObject(jsonWriter, sansfamilleDescripteurList.getDescripteur(i), fieldFilter);
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    public static void termObject(JSONWriter jsonWriter, Term term, FieldFilter fieldFilter) throws IOException {
        jsonWriter.object();
        AtlasJsonUtils.termProperties(jsonWriter, term, fieldFilter);
        jsonWriter.endObject();
    }

    public static void termProperties(JSONWriter jsonWriter, Term term, FieldFilter fieldFilter) throws IOException {
        short type = term.getTermType();
        switch (type) {
            case 1: {
                AtlasJsonUtils.descripteurProperties(jsonWriter, (Descripteur)term, fieldFilter);
                break;
            }
            case 2: {
                AtlasJsonUtils.grilleProperties(jsonWriter, (Grille)term, fieldFilter, false);
                break;
            }
            case 3: 
            case 4: {
                AtlasJsonUtils.contexteProperties(jsonWriter, (Contexte)term, fieldFilter, false);
                break;
            }
            default: {
                AtlasJsonUtils.commonProperties(jsonWriter, term, fieldFilter);
            }
        }
    }

    public static void grilleObject(JSONWriter jsonWriter, Grille grille, FieldFilter fieldFilter, boolean withChildren) throws IOException {
        jsonWriter.object();
        AtlasJsonUtils.grilleProperties(jsonWriter, grille, fieldFilter, withChildren);
        jsonWriter.endObject();
    }

    public static void grilleProperties(JSONWriter jsonWriter, Grille grille, FieldFilter fieldFilter, boolean withChildren) throws IOException {
        ContexteList firstLevel;
        int firstCount;
        AtlasJsonUtils.commonProperties(jsonWriter, grille, fieldFilter);
        if (fieldFilter.with(12)) {
            jsonWriter.key("name");
            jsonWriter.value((Object)grille.getGrilleName());
        }
        if (withChildren && (firstCount = (firstLevel = grille.getFirstLevelContexteList()).getContexteCount()) > 0) {
            jsonWriter.key("contexteArray");
            jsonWriter.array();
            for (int i = 0; i < firstCount; ++i) {
                AtlasJsonUtils.contexteObject(jsonWriter, firstLevel.getContexte(i), fieldFilter, withChildren);
            }
            jsonWriter.endArray();
        }
    }

    public static void contexteObject(JSONWriter jsonWriter, Contexte contexte, FieldFilter fieldFilter, boolean withChildren) throws IOException {
        jsonWriter.object();
        AtlasJsonUtils.contexteProperties(jsonWriter, contexte, fieldFilter, withChildren);
        jsonWriter.endObject();
    }

    public static void contexteProperties(JSONWriter jsonWriter, Contexte contexte, FieldFilter fieldFilter, boolean withChildren) throws IOException {
        AtlasJsonUtils.commonProperties(jsonWriter, contexte, fieldFilter);
        short type = contexte.getTermType();
        if (type == 3 || type == 4) {
            ContexteList children;
            int childCount;
            Contexte parent;
            if (fieldFilter.with(3)) {
                jsonWriter.key("idctxt");
                jsonWriter.value((Object)contexte.getIdctxt());
            }
            if (fieldFilter.with(5)) {
                jsonWriter.key("grilleCode");
                jsonWriter.value((long)contexte.getGrille().getCode());
            }
            if (fieldFilter.with(4)) {
                jsonWriter.key("grilleName");
                jsonWriter.value((Object)contexte.getGrille().getGrilleName());
            }
            if (fieldFilter.with(6)) {
                jsonWriter.key("index");
                jsonWriter.value((long)contexte.getChildIndex());
            }
            if (fieldFilter.with(7) && (parent = contexte.getParent()) != null) {
                jsonWriter.key("parentCode");
                jsonWriter.value((long)contexte.getCode());
            }
            if (fieldFilter.with(8) && (parent = contexte.getParent()) != null) {
                jsonWriter.key("parentIdctxt");
                jsonWriter.value((long)contexte.getCode());
            }
            if (fieldFilter.with(14) && (parent = contexte.getParent()) != null) {
                jsonWriter.key("ancestors");
                jsonWriter.array();
                AtlasJsonUtils.writeAncestor(jsonWriter, parent);
                jsonWriter.endArray();
            }
            jsonWriter.key("active");
            jsonWriter.value(contexte.isActive());
            if (withChildren && (childCount = (children = contexte.getChildren()).getContexteCount()) > 0) {
                jsonWriter.key("contexteArray");
                jsonWriter.array();
                for (int i = 0; i < childCount; ++i) {
                    AtlasJsonUtils.contexteObject(jsonWriter, children.getContexte(i), fieldFilter, withChildren);
                }
                jsonWriter.endArray();
            }
        }
    }

    public static void descripteurObject(JSONWriter jsonWriter, Descripteur descripteur, FieldFilter fieldFilter) throws IOException {
        jsonWriter.object();
        AtlasJsonUtils.descripteurProperties(jsonWriter, descripteur, fieldFilter);
        jsonWriter.endObject();
    }

    public static void descripteurProperties(JSONWriter jsonWriter, Descripteur descripteur, FieldFilter fieldFilter) throws IOException {
        Attribute attribute;
        Contexte famille;
        if (fieldFilter.with(9)) {
            jsonWriter.key("iddesc");
            jsonWriter.value((Object)descripteur.getIddesc().toString());
        }
        if (fieldFilter.with(10) && !StructureUtils.isSansfamilleContexte(famille = descripteur.getFamille())) {
            jsonWriter.key("familleCode");
            jsonWriter.value((long)famille.getCode());
        }
        if (fieldFilter.with(11) && !StructureUtils.isSansfamilleContexte(famille = descripteur.getFamille())) {
            jsonWriter.key("familleIdctxt");
            jsonWriter.value((Object)famille.getIdctxt());
        }
        if (fieldFilter.with(13) && !StructureUtils.isSansfamilleContexte(famille = descripteur.getFamille()) && (attribute = famille.getAttributes().getAttribute(AtlasAttributes.COLOR_KEY)) != null) {
            jsonWriter.key("familleColor");
            jsonWriter.value((Object)attribute.getFirstValue());
        }
        AtlasJsonUtils.commonProperties(jsonWriter, descripteur, fieldFilter);
    }

    public static void commonProperties(JSONWriter jsonWriter, Term terme, FieldFilter fieldFilter) throws IOException {
        jsonWriter.key("code");
        jsonWriter.value((long)terme.getCode());
        if (fieldFilter.with(0)) {
            jsonWriter.key("type");
            jsonWriter.value((long)terme.getTermType());
        }
        if (fieldFilter.with(1)) {
            boolean libelleInsert = false;
            for (Label label : terme.getLabels()) {
                Lang lang = label.getLang();
                if (!fieldFilter.acceptLibelle(lang)) continue;
                if (!libelleInsert) {
                    jsonWriter.key("libelles");
                    jsonWriter.array();
                    libelleInsert = true;
                }
                jsonWriter.object();
                jsonWriter.key("lang");
                jsonWriter.value((Object)lang.toString());
                jsonWriter.key("lib");
                jsonWriter.value((Object)label.getLabelString());
                jsonWriter.endObject();
            }
            if (libelleInsert) {
                jsonWriter.endArray();
            }
        }
        if (fieldFilter.with(2)) {
            boolean attributeInsert = false;
            for (Attribute attribute : terme.getAttributes()) {
                AttributeKey attributeKey = attribute.getAttributeKey();
                if (!fieldFilter.acceptAttribute(attributeKey)) continue;
                if (!attributeInsert) {
                    jsonWriter.key("attrs");
                    jsonWriter.object();
                    attributeInsert = true;
                }
                jsonWriter.key(attributeKey.toString());
                jsonWriter.array();
                for (String value : attribute) {
                    jsonWriter.value((Object)value);
                }
                jsonWriter.endArray();
            }
            if (attributeInsert) {
                jsonWriter.endObject();
            }
        }
    }

    private static void writeAncestor(JSONWriter jsonWriter, Contexte contexte) throws IOException {
        jsonWriter.object();
        jsonWriter.key("code");
        jsonWriter.value((long)contexte.getCode());
        jsonWriter.key("idctxt");
        jsonWriter.value((Object)contexte.getIdctxt());
        jsonWriter.key("active");
        jsonWriter.value(contexte.isActive());
        jsonWriter.endObject();
        Contexte parent = contexte.getParent();
        if (parent != null) {
            AtlasJsonUtils.writeAncestor(jsonWriter, parent);
        }
    }
}

