/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs.secteurangulaire;

import java.awt.Dimension;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.ventilation.Secteur;
import net.mapeadores.util.geometry.CartesianPoint;
import net.mapeadores.util.geometry.CartesianUtils;

public final class SecteurAngulaireUtils {
    private SecteurAngulaireUtils() {
    }

    public static double getCartesianEllipseAngle(SecteurAngulaire secteurAngulaire, float t) {
        short angleType = secteurAngulaire.getArcType();
        if (angleType == 2) {
            return Math.PI * 2 * (double)t;
        }
        if (angleType == 1) {
            return CartesianUtils.modulo2pi((double)(secteurAngulaire.getFirstSommet().getCartesianEllipseAngle() + Math.PI * (double)t));
        }
        FaisceauAngulaire faisceauAngulaire = secteurAngulaire.getFaisceauAngulaire();
        double xyRatio = faisceauAngulaire.getXYRatio();
        double trigoAngle = secteurAngulaire.getFirstSommet().getCartesianTrigoAngle() + (double)t * faisceauAngulaire.getCartesianTrigoSecteurArc();
        return SecteurAngulaireUtils.getCartesianEllipseAngle(trigoAngle, xyRatio);
    }

    public static double getCartesianEllipseAngle(double trigoAngle, double xyRatio) {
        double x = Math.cos(trigoAngle) * xyRatio;
        double y = Math.sin(trigoAngle);
        double norme = Math.sqrt(x * x + y * y);
        double theta = Math.acos(x / norme);
        if (y < 0.0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }

    public static Secteur getSecteur(FaisceauAngulaire faisceauAngulaire, CartesianPoint P) {
        CartesianPoint cartesianCenter = faisceauAngulaire.getCartesianCenter();
        if (cartesianCenter == null) {
            return null;
        }
        Secteur secteur = null;
        Dimension AB = faisceauAngulaire.getAB();
        if (SecteurAngulaireUtils.getProximite(cartesianCenter, P, AB) < 1.0f) {
            double angle = CartesianPoint.angle((CartesianPoint)cartesianCenter, (CartesianPoint)P);
            int secteurAngulaireCount = faisceauAngulaire.getSecteurAngulaireCount();
            for (int i = 0; i < secteurAngulaireCount; ++i) {
                SecteurAngulaire secteurAngulaire = faisceauAngulaire.getSecteurAngulaire(i);
                if (!SecteurAngulaireUtils.containsCartesianAngle(secteurAngulaire, angle)) continue;
                return secteurAngulaire.getSecteur();
            }
        }
        return secteur;
    }

    private static boolean containsCartesianAngle(SecteurAngulaire secteurAngulaire, double cartesianAngle) {
        double secondAngle;
        double firstAngle = secteurAngulaire.getFirstSommet().getCartesianEllipseAngle();
        if (firstAngle < (secondAngle = secteurAngulaire.getSecondSommet().getCartesianEllipseAngle())) {
            return cartesianAngle > firstAngle && cartesianAngle < secondAngle;
        }
        return cartesianAngle > firstAngle || cartesianAngle < secondAngle;
    }

    private static float getProximite(CartesianPoint cartesianCenter, CartesianPoint P, Dimension AB) {
        if (cartesianCenter == null) {
            return 999.9f;
        }
        double angle = CartesianPoint.angle((CartesianPoint)cartesianCenter, (CartesianPoint)P);
        float pourcentage = (float)(CartesianPoint.norme((CartesianPoint)cartesianCenter, (CartesianPoint)P) / CartesianPoint.getNormeOnEllipse((double)angle, (Dimension)AB));
        return pourcentage;
    }
}

