/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.AtlasConstants;
import net.desmodo.atlas.AttributeConstants;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.l10n.AtlasL10n;
import net.desmodo.atlas.structure.Grille;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeDefBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

public class AtlasAttributes
implements AtlasConstants,
AttributeConstants {
    public static final String FORMATTYPE_DEFOBJ = "format_type";
    public static final CheckedNameSpace ATLAS_NAMESPACE = CheckedNameSpace.build((CharSequence)"atlas");
    public static final AttributeKey URL_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"url");
    public static final AttributeKey POIDS_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"poids");
    public static final AttributeKey AUTHORS_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"authors");
    public static final AttributeKey DATE_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"date");
    public static final AttributeKey SOURCE_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"source");
    public static final AttributeKey COLOR_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"color");
    public static final AttributeKey VENTILATIONNATURELLE_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"ventilationnaturelle");
    public static final AttributeKey VENTILATIONS_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"ventilations");
    public static final AttributeKey GENERATION_DATE_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"generation.date");
    public static final AttributeKey SCOPE_KEY = AttributeKey.build((CheckedNameSpace)ATLAS_NAMESPACE, (CharSequence)"scope");
    public static final List<AttributeDef> STANDARD_ATLASATTRIBUTEDEFLIST;
    public static final Attribute NONE_VENTILATIONS;
    public static final Attribute ALL_VENTILATIONS;
    private static final Map<AttributeKey, AttributeDef> standardAttributeMap;
    private static final Map<String, List<AttributeDef>> scopeMap;

    private AtlasAttributes() {
    }

    public static boolean owsToAtlasNameSpace(AttributeKey attributeKey) {
        return attributeKey.getNameSpace().equals("atlas");
    }

    public static AttributeDef getStandardAttributeDef(AttributeKey attributeKey) {
        return standardAttributeMap.get(attributeKey);
    }

    public static List<AttributeDef> getStandardAttributeDefList(String scope) {
        List<AttributeDef> attributeDefList = scopeMap.get(scope);
        if (attributeDefList == null) {
            return AttributeUtils.EMPTY_ATTRIBUTEDEFLIST;
        }
        return attributeDefList;
    }

    public static Color getColor(Term term) {
        return AtlasAttributes.getColor(term.getAttributes());
    }

    public static Color getColor(Attributes attributes) {
        Attribute attribute = attributes.getAttribute(COLOR_KEY);
        if (attribute != null) {
            try {
                Color color = Color.decode(attribute.getFirstValue());
                return color;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (attributes instanceof Grille) {
            return Color.DARK_GRAY;
        }
        return Color.GRAY;
    }

    public static String getFormatType(AttributeDef attributeDef) {
        Object obj = attributeDef.getDefObject(FORMATTYPE_DEFOBJ);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private static void initLabels(AttributeDefBuilder attributeDefBuilder) {
        Labels labels = AtlasL10n.getAttributeLabels(attributeDefBuilder.getAttributeKey());
        if (labels == null) {
            return;
        }
        for (Label label : labels) {
            attributeDefBuilder.putLabel(label);
        }
    }

    static {
        CleanedString noneString = CleanedString.newInstance((CharSequence)"_none");
        NONE_VENTILATIONS = AttributeBuilder.toAttribute((AttributeKey)VENTILATIONS_KEY, (CleanedString)noneString);
        CleanedString allString = CleanedString.newInstance((CharSequence)"_all");
        ALL_VENTILATIONS = AttributeBuilder.toAttribute((AttributeKey)VENTILATIONS_KEY, (CleanedString)allString);
        standardAttributeMap = new HashMap<AttributeKey, AttributeDef>();
        scopeMap = new HashMap<String, List<AttributeDef>>();
        ArrayList<AttributeDef> list = new ArrayList<AttributeDef>();
        AttributeDefBuilder authorsBuilder = new AttributeDefBuilder(AUTHORS_KEY);
        authorsBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "titre");
        AtlasAttributes.initLabels(authorsBuilder);
        list.add(authorsBuilder.toAttributeDef());
        AttributeDefBuilder dateBuilder = new AttributeDefBuilder(DATE_KEY);
        dateBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"datation");
        dateBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "titre");
        AtlasAttributes.initLabels(dateBuilder);
        list.add(dateBuilder.toAttributeDef());
        AttributeDefBuilder sourceBuilder = new AttributeDefBuilder(SOURCE_KEY);
        sourceBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "metadata");
        AtlasAttributes.initLabels(sourceBuilder);
        list.add(sourceBuilder.toAttributeDef());
        AttributeDefBuilder urlBuilder = new AttributeDefBuilder(URL_KEY);
        urlBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"url");
        urlBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "descripteur");
        AtlasAttributes.initLabels(urlBuilder);
        list.add(urlBuilder.toAttributeDef());
        AttributeDefBuilder poidsBuilder = new AttributeDefBuilder(POIDS_KEY);
        poidsBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"integer_positive");
        poidsBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "descripteur");
        AtlasAttributes.initLabels(poidsBuilder);
        list.add(poidsBuilder.toAttributeDef());
        AttributeDefBuilder colorBuilder = new AttributeDefBuilder(COLOR_KEY);
        colorBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"color");
        colorBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "grille");
        colorBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "contexte");
        colorBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "famille");
        AtlasAttributes.initLabels(colorBuilder);
        list.add(colorBuilder.toAttributeDef());
        AttributeDefBuilder ventilationnaturelleBuilder = new AttributeDefBuilder(VENTILATIONNATURELLE_KEY);
        ventilationnaturelleBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"atlas:ventilation");
        ventilationnaturelleBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "contexte");
        ventilationnaturelleBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "descripteur");
        ventilationnaturelleBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "famille");
        AtlasAttributes.initLabels(ventilationnaturelleBuilder);
        list.add(ventilationnaturelleBuilder.toAttributeDef());
        AttributeDefBuilder ventilationsBuilder = new AttributeDefBuilder(VENTILATIONS_KEY);
        ventilationsBuilder.putDefObject(FORMATTYPE_DEFOBJ, (Object)"atlas:ventilations");
        ventilationsBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "contexte");
        ventilationsBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "descripteur");
        ventilationsBuilder.getAttributesBuilder().appendValue(SCOPE_KEY, "famille");
        AtlasAttributes.initLabels(ventilationsBuilder);
        list.add(ventilationsBuilder.toAttributeDef());
        STANDARD_ATLASATTRIBUTEDEFLIST = AttributeUtils.toImmutableList(list);
        HashMap<String, ArrayList<AttributeDef>> tempScopeMap = new HashMap<String, ArrayList<AttributeDef>>();
        for (AttributeDef attributeDef : list) {
            standardAttributeMap.put(attributeDef.getAttributeKey(), attributeDef);
            Attribute scopeAttribute = attributeDef.getAttributes().getAttribute(SCOPE_KEY);
            if (scopeAttribute == null) continue;
            int scopeLength = scopeAttribute.size();
            for (int i = 0; i < scopeLength; ++i) {
                String scope = (String)scopeAttribute.get(i);
                ArrayList<AttributeDef> deflist = (ArrayList<AttributeDef>)tempScopeMap.get(scope);
                if (deflist == null) {
                    deflist = new ArrayList<AttributeDef>();
                    tempScopeMap.put(scope, deflist);
                }
                deflist.add(attributeDef);
            }
        }
        for (Map.Entry entry : tempScopeMap.entrySet()) {
            scopeMap.put((String)entry.getKey(), AttributeUtils.toImmutableList((Collection)((Collection)entry.getValue())));
        }
    }
}

