/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.commands;

import fr.exemole.bdfext.desmoservice.Desmoservice;
import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.importation.SessionImportEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import net.desmodo.atlas.io.AtlasIOException;
import net.desmodo.atlas.session.SessionIO;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.xml.dsmd.DefaultDsmdDOMErrorHandler;
import net.desmodo.atlas.xml.dsmd.DsmdDOMErrorHandler;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.exceptions.NestedClassLoaderException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class DsmdImportCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DsmdImport";
    public static final String COMMANDKEY = "_ DSM-03";
    public static final String NAME_PARAMNAME = "name";
    public static final String FILE_PARAMNAME = "file";
    private final DesmoserviceContext desmoserviceContext;
    private String name;

    public DsmdImportCommand(BdfServer bdfServer, RequestMap requestMap, DesmoserviceContext desmoserviceContext) {
        super(bdfServer, requestMap);
        this.desmoserviceContext = desmoserviceContext;
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        SessionSource sessionSource;
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter((String)FILE_PARAMNAME);
        }
        if (fileValue.length() < 2L) {
            fileValue.free();
            throw BdfErrors.error((String)"_ error.empty.file");
        }
        try {
            DefaultDsmdDOMErrorHandler dsmdDOMErrorHandler = new DefaultDsmdDOMErrorHandler();
            SessionIO.setAtlasFactory("net.desmodo.atlas.impl.AtlasFactory");
            sessionSource = SessionIO.loadSession(fileValue.getInputStream(), (DsmdDOMErrorHandler)dsmdDOMErrorHandler);
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException((IOException)ioe);
        }
        catch (AtlasIOException atlasIOException) {
            throw BdfErrors.error((String)"_ error.exception.io", (Object[])new Object[]{atlasIOException.getMessage()});
        }
        catch (ReflectiveOperationException cnfe) {
            throw new NestedClassLoaderException((Exception)cnfe);
        }
        finally {
            fileValue.free();
        }
        try (EditSession session = this.startEditSession(Desmoservice.DOMAIN, COMMANDNAME);){
            SessionImportEngine.run(this.name, sessionSource, (BdfParameters)this.requestHandler, this.desmoserviceContext, session.getFichothequeEditor());
        }
        this.setDone("_ done.fr-exemole-desmoservice.dsmdimport", new Object[]{fileValue.getName(), this.name});
    }

    protected void checkParameters() throws ErrorMessageException {
        this.name = this.getMandatory(NAME_PARAMNAME).trim();
        if (this.name.length() == 0) {
            throw BdfErrors.error((String)"_ error.empty.fr-exemole-desmoservice.desmoname");
        }
        if (!StringUtils.isTechnicalName((String)this.name, (boolean)true)) {
            throw BdfErrors.error((String)"_ error.wrong.fr-exemole-desmoservice.desmoname", (Object[])new Object[]{this.name});
        }
        Thesaurus atlasThesaurus = this.desmoserviceContext.getCoreAliasHolder().getThesaurus("atlas");
        if (atlasThesaurus.getMotcleByIdalpha(this.name) != null) {
            throw BdfErrors.error((String)"_ error.existing.fr-exemole-desmoservice.desmoname", (Object[])new Object[]{this.name});
        }
    }
}

