/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.event.AtlasMetadataListener;
import net.desmodo.atlas.metadata.AtlasAttributeDefList;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Labels;

class BdfAtlasMetadata
implements AtlasMetadata {
    private static final DateTimeFormatter INSTANT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss,SSS'Z'");
    private final BdfAtlas bdfAtlas;
    private final Titre titre;
    private Langs workingLangs;
    private final AttributesCache attributesCache = new AttributesCache();

    private BdfAtlasMetadata(BdfAtlas bdfAtlas, Motcle motcle) {
        this.bdfAtlas = bdfAtlas;
        this.titre = new Titre(motcle);
    }

    static BdfAtlasMetadata init(BdfAtlas bdfAtlas, Motcle motcle, AliasHolder coreAliasHolder) {
        String currentDate = INSTANT_FORMAT.format(Instant.now());
        BdfAtlasMetadata metadata = new BdfAtlasMetadata(bdfAtlas, motcle);
        FicheItems langsList = (FicheItems)bdfAtlas.atlasFichePointeur.getValue(coreAliasHolder.getCorpusField("atlas_langs"));
        Langs workingLangs = LangsUtils.EMPTY_LANGS;
        if (langsList != null) {
            ArrayList<Lang> result = new ArrayList<Lang>();
            for (FicheItem ficheItem : langsList) {
                if (!(ficheItem instanceof LanguageItem)) continue;
                result.add(((LanguageItem)ficheItem).getLang());
            }
            workingLangs = LangsUtils.fromCollection(result);
        }
        metadata.workingLangs = workingLangs;
        AttributeBuilder dateAttributeBuilder = new AttributeBuilder(AtlasAttributes.GENERATION_DATE_KEY);
        dateAttributeBuilder.addValue(currentDate);
        metadata.putAttribute(dateAttributeBuilder.toAttribute());
        return metadata;
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public Term getTitre() {
        return this.titre;
    }

    @Override
    public void addAtlasMetadataListener(AtlasMetadataListener atlasMetadataListener) {
    }

    @Override
    public void removeAtlasMetadataListener(AtlasMetadataListener atlasMetadataListener) {
    }

    @Override
    public Attributes getAttributes() {
        return this.attributesCache.getAttributes();
    }

    @Override
    public Langs getWorkingLangs() {
        return this.workingLangs;
    }

    @Override
    public AttributeDef getAttributeDef(AttributeKey attributeKey) {
        return AtlasAttributes.getStandardAttributeDef(attributeKey);
    }

    @Override
    public List<AttributeDef> getAttributeListByScope(String scope) {
        return AtlasAttributes.getStandardAttributeDefList(scope);
    }

    @Override
    public AtlasAttributeDefList getAtlasAttributeDefList() {
        return AtlasUtils.EMPTY_ATLASATTRIBUTEDEFLIST;
    }

    boolean putAttribute(Attribute attribute) {
        return this.attributesCache.putAttribute(attribute);
    }

    private class Titre
    implements Term {
        private final Motcle motcle;

        private Titre(Motcle motcle) {
            this.motcle = motcle;
        }

        @Override
        public Atlas getAtlas() {
            return BdfAtlasMetadata.this.bdfAtlas;
        }

        @Override
        public short getTermType() {
            return 8;
        }

        @Override
        public Attributes getAttributes() {
            return this.motcle.getAttributes();
        }

        @Override
        public int getCode() {
            return 8;
        }

        @Override
        public Labels getLabels() {
            return this.motcle.getLabels();
        }
    }
}

