/* global BDF*/

/**
 * Objet global définissant l'espace de nom Desmography
 * 
 * @namespace Dashboard
 */
var Dashboard = {};

Dashboard.REGISTRATION_NAME = "desmography";
Dashboard.ATLAS = "";
Dashboard.LANG = "";
Dashboard.LANGS = [];
Dashboard.VERSION = 1;
Dashboard.PARAMETERS = {};
Dashboard.CORPUSMAP = {};

Dashboard.render = function (name, context) {
    return BDF.render(Dashboard.REGISTRATION_NAME + ":dashboard", name, context);
};

Dashboard.getCommandAction = function () {
    return BDF.URL + "ext_" + Dashboard.REGISTRATION_NAME;
};

Dashboard.initAction = function () {
    
    _init("showTab", function () {
        var $this = $(this);
        var group = $this.data("group");
        var name = $this.data("name");
        $("[data-role='tabbody'][data-group='" + group + "'][data-name!='" + name + "']").addClass("hidden");
        $("[data-role='tabbody'][data-group='" + group + "'][data-name='" + name + "']").removeClass("hidden");
    });
    
    _init("addGrid", function () {
        var $this = $(this);
        Overlay.start(_getTermAddOverlay("_ link.desmography.addgrid", "grids", "", Dashboard.Grids.update));
    });
    
    _init("addSector", function () {
        var $this = $(this);
        Overlay.start(_getTermAddOverlay("_ link.desmography.addsector", "subsectors", $this.data("superiorName"), Dashboard.Grids.update));
    });
    
    _init("addSubsector", function () {
        var $this = $(this);
        Overlay.start(_getTermAddOverlay("_ link.desmography.addsubsector", "subsectors", $this.data("superiorName"), Dashboard.Grids.update));
    });
    
    _init("addFamily", function () {
        var $this = $(this);
        Overlay.start(_getTermAddOverlay("_ link.desmography.addfamily", "rootfamilies", "", Dashboard.Families.update));
    });
    
    _init("addSubfamily", function () {
        var $this = $(this);
        Overlay.start(_getTermAddOverlay("_ link.desmography.addsubfamily", "subfamilies", $this.data("superiorName"), Dashboard.Families.update));
    });
    
    _init("editIndexRelations", Dashboard.Parameters.editIndexRelations);
    
    _init("editTableExport", Dashboard.Parameters.editTableExport);
    
    _init("editCorpusList", Dashboard.Parameters.editCorpusList);
    
    _init("editNewResource", Dashboard.Parameters.editNewResource);
    
    function _init(name, click) {
        $("body").on("click", "[data-action='" + name + "']", click);
    }
    
    
    function _getTermAddOverlay(titleKey, relation, superior, callback) {
        return {
            header: BDF.escapeLoc(titleKey),
            content: Dashboard.render("overlay-termadd-content", {atlas: Dashboard.ATLAS, langs: Dashboard.LANGS, relation: relation, superior: superior}),
            footer: Dashboard.render("overlay-termadd-footer", {}),
            formAttrs: {
                action: Dashboard.getCommandAction(),
                method: "POST"
            },
            afterStart: function ($overlayDialog) {
                BDF.Deploy.init($overlayDialog);
                BDF.Appelant.init($overlayDialog);
            },
            ajaxForm: {
                dataType: "json",
                success: function (data, textStatus, jqXHR, $form) {
                    var done = BDF.Ajax.checkError(data);
                    if (done) {
                        Overlay.end($form, function() {
                            callback();
                        });
                    }
                }
            }
        };
    }
    
};


/******************************************************************************
 * Fonctions d'initialisation
 ******************************************************************************/

Dashboard.$Content = function (contentName, options) {
   var query = "";
   if ((options) && (options.hasOwnProperty("checked"))) {
       if (options.checked) {
           query += ":checked";
       } else {
           query += ":not(:checked)";
       }
   }
   
   query += "[data-content='" + contentName + "']";
   if (options) {
       for(var key in options) {
            if (key !== "checked") {
                query += "[" + BDF.toDataAttribute(key) + "='" + options[key] + "']";
            }
        }
   }
   return $(query);
};


/******************************************************************************
 * Fonctions statiques d'appel Ajax
 ******************************************************************************/

Dashboard.Ajax = {};

Dashboard.Ajax.getApiUrl = function () {
    return BDF.URL + "ext/" + Dashboard.REGISTRATION_NAME + "/json";
};

Dashboard.Ajax.getActionUrl = function () {
    return BDF.URL + "ext_" + Dashboard.REGISTRATION_NAME;
};

Dashboard.Ajax.loadGrids = function (gridsCallback) {
    $.ajax({
        url: Dashboard.Ajax.getApiUrl(),
        data: {
            lang: Dashboard.LANG,
            version: Dashboard.VERSION,
            atlas: Dashboard.ATLAS,
            type: "grids"
        },
        dataType: BDF.jsonDataType,
        success: function (data, textStatus) {
            Dashboard.Ajax.success(data, gridsCallback);
        }
    });
};

Dashboard.Ajax.loadFamilies = function (gridsCallback) {
    $.ajax({
        url: Dashboard.Ajax.getApiUrl(),
        data: {
            lang: Dashboard.LANG,
            version: Dashboard.VERSION,
            atlas: Dashboard.ATLAS,
            type: "families"
        },
        dataType: BDF.jsonDataType,
        success: function (data, textStatus) {
            Dashboard.Ajax.success(data, gridsCallback);
        }
    });
};

Dashboard.Ajax.loadParameters = function (parametersCallback) {
    $.ajax({
        url: Dashboard.Ajax.getActionUrl(),
        data: {
            json: "parameters",
            atlas: Dashboard.ATLAS
        },
        dataType: BDF.jsonDataType,
        success: function (data, textStatus) {
            Dashboard.Ajax.success(data, parametersCallback);
        }
    });
};

Dashboard.Ajax.success = function (data, callback) {
    if (data.commandMessage) {
        if (!BDF.Ajax.checkError(data)) {
            return false;
        }
    }
    callback(data);
};

/******************************************************************************
 * Initialisation
 ******************************************************************************/

$(function () {
    BDF.initTemplates();
    $("#menubarPane").html(Dashboard.render("pane-menubar", {}));
    $("#mainPane").html(Dashboard.render("pane-main", {}));
    Dashboard.Grids.init();
    Dashboard.Families.init();
    Dashboard.Parameters.init();
    Dashboard.initAction();
});