/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.sync;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.sync.AtlasSync;
import fr.exemole.bdfext.desmography.sync.RelationSync;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.importation.engines.CorpusImportEngine;
import fr.exemole.bdfserver.tools.sync.SyncEngine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.sync.ThesaurusSync;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;

public final class AtlasSyncEngine {
    private AtlasSyncEngine() {
    }

    public static void run(EditSession editSession, BdfParameters bdfParameters, AtlasSync atlasSync, Atlas atlas) {
        SyncEngine.runThesaurusSync((EditSession)editSession, (BdfParameters)bdfParameters, (ThesaurusSync)atlasSync.getThesaurusSync(), (Thesaurus)atlas.getTermThesaurus());
        RelationScan relationScan = new RelationScan(atlasSync, atlas);
        relationScan.scan();
        relationScan.flush(editSession, bdfParameters);
    }

    private static class RelationScan {
        private final AtlasSync atlasSync;
        private final Thesaurus termThesaurus;
        private final Corpus relationCorpus;
        private final EditCorpusImportBuilder changeBuilder;
        private final EditCorpusImportBuilder creationBuilder;
        private final RemoveCorpusImportBuilder removeBuilder;
        private final Map<Integer, FicheMeta> toRemoveMap = new HashMap<Integer, FicheMeta>();
        private final IncludeKey superior;
        private final IncludeKey sector;
        private final IncludeKey inferior;

        RelationScan(AtlasSync atlasSync, Atlas atlas) {
            this.atlasSync = atlasSync;
            this.termThesaurus = atlas.getTermThesaurus();
            this.relationCorpus = atlas.getRelationCorpus();
            this.changeBuilder = EditCorpusImportBuilder.init((Corpus)this.relationCorpus);
            this.creationBuilder = EditCorpusImportBuilder.init((Corpus)this.relationCorpus);
            this.removeBuilder = RemoveCorpusImportBuilder.init((Corpus)this.relationCorpus);
            SubsetKey thesaurusKey = atlas.getTermThesaurus().getSubsetKey();
            this.superior = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"superior", (int)-1);
            this.sector = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"sector", (int)-1);
            this.inferior = IncludeKey.newInstance((SubsetKey)thesaurusKey, (String)"inferior", (int)-1);
        }

        private void scan() {
            for (FicheMeta ficheMeta : this.relationCorpus.getFicheMetaList()) {
                this.toRemoveMap.put(ficheMeta.getId(), ficheMeta);
            }
            for (RelationSync relationSync : this.atlasSync.getRelationSyncList()) {
                EditFicheImportBuilder ficheImportBuilder;
                int id = relationSync.getId();
                FicheMeta current = this.toRemoveMap.get(id);
                if (current != null) {
                    ficheImportBuilder = this.changeBuilder.getEditFicheImportBuilder(current);
                    this.toRemoveMap.remove(id);
                } else {
                    ficheImportBuilder = this.creationBuilder.getEditFicheImportBuilder(id);
                }
                this.sync(relationSync, ficheImportBuilder);
            }
            for (FicheMeta ficheMeta : this.toRemoveMap.values()) {
                this.removeBuilder.add(ficheMeta);
            }
        }

        private void sync(RelationSync relationSync, EditFicheImportBuilder ficheImportBuilder) {
            ficheImportBuilder.getAttributeChangeBuilder().appendValue(DesmographySpace.RELATIONTYPE_KEY, relationSync.getType());
            TiesImportBuilder tiesImportBuilder = ficheImportBuilder.getTiesImportBuilder();
            this.add(relationSync, this.superior, tiesImportBuilder);
            this.add(relationSync, this.sector, tiesImportBuilder);
            this.add(relationSync, this.inferior, tiesImportBuilder);
        }

        private void add(RelationSync relationSync, IncludeKey includeKey, TiesImportBuilder tiesImportBuilder) {
            List<String> idalphaList = relationSync.getIdalphaList(includeKey.getMode());
            if (idalphaList.isEmpty()) {
                tiesImportBuilder.addRemovedIncludeKey(includeKey);
            } else {
                for (String idalpha : idalphaList) {
                    Motcle term = this.termThesaurus.getMotcleByIdalpha(idalpha);
                    if (term == null) continue;
                    tiesImportBuilder.addReplaceTieImport(ImportationUtils.toTieImport((IncludeKey)includeKey, (Subset)this.termThesaurus, (int)term.getId(), (int)1));
                }
            }
        }

        private void flush(EditSession editSession, BdfParameters bdfParameters) {
            this.flush(editSession, bdfParameters, this.changeBuilder.toCorpusImport());
            this.flush(editSession, bdfParameters, this.creationBuilder.toCorpusImport());
            this.flush(editSession, bdfParameters, this.removeBuilder.toCorpusImport());
        }

        private void flush(EditSession editSession, BdfParameters bdfParameters, CorpusImport corpusImport) {
            CorpusImportEngine.runCorpusImport((EditSession)editSession, (BdfParameters)bdfParameters, (CorpusImport)corpusImport);
        }
    }
}

