/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.json.Extract;
import fr.exemole.bdfext.desmography.json.RelationJson;
import fr.exemole.bdfext.desmography.json.ResourceJson;
import fr.exemole.bdfext.desmography.json.TermJson;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Tie;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.CommonJson;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Labels;

public class SummaryJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Motcle term;
    private final Lang lang;
    private final PermissionSummary permissionSummary;
    private final CellConverter propertiesCellConverter;

    public SummaryJsonProducer(Atlas atlas, Motcle term, Lang lang, @Nullable PermissionSummary permissionSummary, CellConverter propertiesCellConverter) {
        this.atlas = atlas;
        this.term = term;
        this.lang = lang;
        this.permissionSummary = permissionSummary;
        this.propertiesCellConverter = propertiesCellConverter;
    }

    public void writeJson(Appendable appendable) throws IOException {
        Extract extract = new Extract();
        SortedMap<String, ByType> byTypeMap = this.getByTypeMap();
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("summary");
        jw.object();
        extract.addTerm(this.term);
        TermJson.dataProperties(jw, this.atlas, this.term, this.lang);
        jw.key("labels");
        CommonJson.object((JSONWriter)jw, (Labels)this.term.getLabels());
        TermJson.familiesProperty(jw, this.atlas, this.term, extract);
        jw.key("relationship");
        jw.object();
        for (Map.Entry<String, ByType> entry : byTypeMap.entrySet()) {
            SortedMap map = entry.getValue().getModeMap();
            jw.key(entry.getKey());
            jw.object();
            for (Map.Entry modeEntry : map.entrySet()) {
                String mode = (String)modeEntry.getKey();
                jw.key(mode);
                jw.array();
                for (FicheMeta relation : ((ByMode)modeEntry.getValue()).getSet()) {
                    jw.value((Object)extract.addRelation(relation));
                }
                jw.endArray();
            }
            jw.endObject();
        }
        jw.endObject();
        TermJson.indexationProperty(jw, this.atlas, this.term, extract);
        jw.endObject();
        RelationJson.properties(jw, this.atlas, extract);
        TermJson.properties(jw, this.atlas, extract, this.lang, false);
        ResourceJson.properties(jw, this.atlas, extract, this.lang, this.propertiesCellConverter, this.permissionSummary);
        jw.endObject();
    }

    private SortedMap<String, ByType> getByTypeMap() {
        TreeMap<String, ByType> byTypeMap = new TreeMap<String, ByType>();
        Junctions junctions = AtlasUtils.getRelationJunctions(this.atlas, this.term);
        for (Junctions.Entry entry : junctions.getEntryList()) {
            FicheMeta relation = (FicheMeta)entry.getSubsetItem();
            String relationType = AtlasUtils.getRelationType(relation);
            ByType byType = this.getByType(relationType, byTypeMap);
            for (Tie tie : entry.getJunction().getTieList()) {
                byType.addTie(tie, relation);
            }
        }
        return byTypeMap;
    }

    private ByType getByType(String relationType, SortedMap<String, ByType> byTypeMap) {
        ByType byType = (ByType)byTypeMap.get(relationType);
        if (byType == null) {
            byType = new ByType(relationType);
            byTypeMap.put(relationType, byType);
        }
        return byType;
    }

    private class ByType {
        private final SortedMap<String, ByMode> modeMap = new TreeMap<String, ByMode>();
        private final String relationType;

        private ByType(String relationType) {
            this.relationType = relationType;
        }

        private void addTie(Tie tie, FicheMeta relation) {
            String mode = tie.getMode();
            if (this.relationType.equals("family") && mode.equals("inferior")) {
                return;
            }
            ByMode byMode = (ByMode)this.modeMap.get(mode);
            if (byMode == null) {
                byMode = new ByMode();
                this.modeMap.put(mode, byMode);
            }
            byMode.add(relation);
        }

        private SortedMap<String, ByMode> getModeMap() {
            return this.modeMap;
        }
    }

    private class ByMode {
        private final Set<FicheMeta> set = new LinkedHashSet<FicheMeta>();

        private ByMode() {
        }

        private void add(FicheMeta relation) {
            this.set.add(relation);
        }

        private Set<FicheMeta> getSet() {
            return this.set;
        }
    }
}

