/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.xml;

import fr.exemole.bdfext.desmography.DsmSpace;
import fr.exemole.bdfext.desmography.DsmdConfSpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasIOLoops;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.dsmd.xml.DsmdXmlUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.io.IOConsumer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class DsmdXMLPart
extends XMLPart {
    public static final String DSMD_VERSION = "1.0";
    private final Set<Integer> usedGridSet = new HashSet<Integer>();
    private final Set<Integer> usedFamilySet = new LinkedHashSet<Integer>();
    private final Set<Integer> usedDescripteurSet = new HashSet<Integer>();
    private final Map<Integer, ContexteInfo> contexteMap = new HashMap<Integer, ContexteInfo>();
    private final Map<Integer, String> familyMap = new HashMap<Integer, String>();
    private final Atlas atlas;
    private final Lang[] langArray;

    public DsmdXMLPart(XMLWriter xmlWriter, Atlas atlas, Lang lang) {
        super(xmlWriter);
        this.atlas = atlas;
        if (lang != null) {
            this.langArray = new Lang[1];
            this.langArray[0] = lang;
        } else {
            Langs langs = atlas.getLangs();
            this.langArray = (Lang[])langs.toArray((Object[])new Lang[langs.size()]);
        }
    }

    public void addDsmd() throws IOException {
        this.startOpenTag("dsmd");
        this.addAttribute("version", DSMD_VERSION);
        this.endOpenTag();
        this.openTag("conf");
        this.addConf();
        this.closeTag("conf");
        this.openTag("atlas");
        this.addMetadata();
        this.addStructure();
        this.addDescripteurs();
        this.addLiens();
        this.closeTag("atlas");
        this.closeTag("dsmd");
    }

    private void addConf() throws IOException {
        Attributes attributes = this.atlas.getTermThesaurus().getThesaurusMetadata().getAttributes();
        for (Attribute attribute : attributes) {
            AttributeKey attributeKey = attribute.getAttributeKey();
            if (!attributeKey.getNameSpace().equals(DsmdConfSpace.NAMESPACE.toString())) continue;
            StringBuilder buf = new StringBuilder();
            for (String value : attribute) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append(value);
            }
            this.startOpenTag("param");
            this.addAttribute("name", attributeKey.getLocalKey());
            this.addAttribute("value", buf.toString());
            this.closeEmptyTag();
        }
    }

    private void addMetadata() throws IOException {
        this.openTag("metadata");
        this.openTag("titre");
        DsmdXmlUtils.addLibElements((XMLWriter)this, AtlasUtils.getTitleLabels(this.atlas), this.langArray);
        DsmdXmlUtils.addAttributes((XMLWriter)this, this.atlas.getTermThesaurus().getThesaurusMetadata().getAttributes());
        this.closeTag("titre");
        this.openTag("langs");
        for (Lang lang : this.langArray) {
            this.addSimpleElement("lang", lang.toString());
        }
        this.closeTag("langs");
        this.closeTag("metadata");
    }

    private void addStructure() throws IOException {
        this.openTag("structure");
        List<Motcle> gridList = AtlasUtils.getGridsList(this.atlas);
        for (Motcle grid : gridList) {
            this.usedGridSet.add(grid.getId());
        }
        for (Motcle grid : gridList) {
            String grilleName = this.getGrilleName(grid);
            this.startOpenTag("grille");
            this.addAttribute("name", grilleName);
            this.endOpenTag();
            DsmdXmlUtils.addLibElements((XMLWriter)this, grid.getLabels(), this.langArray);
            DsmdXmlUtils.addAttributes((XMLWriter)this, grid.getAttributes());
            this.addSubsectors(grid, grilleName);
            this.closeTag("grille");
        }
        this.openTag("familles");
        List<Motcle> rootFamiliesList = AtlasUtils.getRootFamiliesList(this.atlas);
        for (Motcle family : rootFamiliesList) {
            this.usedFamilySet.add(family.getId());
        }
        for (Motcle family : rootFamiliesList) {
            this.addFamily(family);
        }
        this.closeTag("familles");
        this.closeTag("structure");
    }

    private void addSubsectors(Motcle parent, String grilleName) throws IOException {
        AtlasIOLoops.forEachSubsector(this.atlas, parent, (IOConsumer<Motcle>)((IOConsumer)subsector -> this.addSubsector((Motcle)subsector, grilleName)));
    }

    private void addSubsector(Motcle subsector, String grilleName) throws IOException {
        if (!this.usedGridSet.contains(subsector.getId())) {
            String idctxt = this.getIdctxt(subsector);
            this.contexteMap.put(subsector.getId(), new ContexteInfo(grilleName, idctxt));
            Attributes attributes = subsector.getAttributes();
            this.startOpenTag("contexte");
            this.addAttribute("idctxt", idctxt);
            if (DsmSpace.isInactive(attributes)) {
                this.addAttribute("active", "0");
            }
            this.endOpenTag();
            DsmdXmlUtils.addLibElements((XMLWriter)this, subsector.getLabels(), this.langArray);
            DsmdXmlUtils.addAttributes((XMLWriter)this, attributes);
            this.addSubsectors(subsector, grilleName);
            this.closeTag("contexte");
        }
    }

    private void addFamily(Motcle family) throws IOException {
        String idctxt = this.getIdctxt(family);
        this.usedFamilySet.add(family.getId());
        this.familyMap.put(family.getId(), idctxt);
        Attributes attributes = family.getAttributes();
        this.startOpenTag("contexte");
        this.addAttribute("idctxt", idctxt);
        if (DsmSpace.isInactive(attributes)) {
            this.addAttribute("active", "0");
        }
        this.endOpenTag();
        DsmdXmlUtils.addLibElements((XMLWriter)this, family.getLabels(), this.langArray);
        DsmdXmlUtils.addAttributes((XMLWriter)this, attributes);
        AtlasIOLoops.forEachSubfamily(this.atlas, family, (IOConsumer<Motcle>)((IOConsumer)subfamily -> {
            if (!this.usedFamilySet.contains(subfamily.getId())) {
                this.addFamily((Motcle)subfamily);
            }
        }));
        this.closeTag("contexte");
    }

    private void addDescripteurs() throws IOException {
        this.openTag("descripteurs");
        for (Integer id : this.usedFamilySet) {
            Motcle family = this.atlas.getTermThesaurus().getMotcleById(id.intValue());
            this.startOpenTag("infamille");
            this.addAttribute("idctxt", this.getIdctxt(family));
            this.endOpenTag();
            AtlasIOLoops.forEachFamilyMember(this.atlas, family, (IOConsumer<Motcle>)((IOConsumer)member -> this.addDescripteur((Motcle)member)));
            this.closeTag("infamille");
        }
        this.openTag("sansfamille");
        for (Motcle term : this.atlas.getTermThesaurus().getMotcleList()) {
            this.addDescripteur(term);
        }
        this.closeTag("sansfamille");
        this.closeTag("descripteurs");
    }

    private void addDescripteur(Motcle term) throws IOException {
        if (!this.usedDescripteurSet.contains(term.getId())) {
            this.usedDescripteurSet.add(term.getId());
            this.startOpenTag("descripteur");
            this.addAttribute("iddesc", this.getIddesc(term));
            this.endOpenTag();
            DsmdXmlUtils.addLibElements((XMLWriter)this, term.getLabels(), this.langArray);
            DsmdXmlUtils.addAttributes((XMLWriter)this, term.getAttributes());
            this.closeTag("descripteur");
        }
    }

    private void addLiens() throws IOException {
        this.openTag("liens");
        AtlasIOLoops.forEachHierachyRelation(this.atlas, (IOConsumer<FicheMeta>)((IOConsumer)relation -> this.addLhg((FicheMeta)relation)));
        this.closeTag("liens");
    }

    private void addLhg(FicheMeta relation) throws IOException {
        List<Motcle> sectors = AtlasUtils.sectors(this.atlas, relation);
        List<Motcle> superiors = AtlasUtils.superiors(this.atlas, relation);
        List<Motcle> inferiors = AtlasUtils.inferiors(this.atlas, relation);
        Iterator<Motcle> it = sectors.iterator();
        while (it.hasNext()) {
            Motcle sector = it.next();
            if (this.contexteMap.containsKey(sector.getId())) continue;
            it.remove();
        }
        for (Motcle superior : superiors) {
            if (sectors.isEmpty()) {
                this.openTag("lhg");
                this.openTag("desc-ctxt");
                this.addDesc(superior);
                this.closeTag("desc-ctxt");
                for (Motcle inferior : inferiors) {
                    this.addDesc(inferior);
                }
                this.closeTag("lhg");
                continue;
            }
            for (Motcle sector : sectors) {
                ContexteInfo contexteInfo = this.contexteMap.get(sector.getId());
                this.openTag("lhg");
                this.openTag("desc-ctxt");
                this.addDesc(superior);
                this.startOpenTag("ctxt");
                this.addAttribute("grille", contexteInfo.grilleName);
                this.addAttribute("idctxt", contexteInfo.idctxt);
                this.closeEmptyTag();
                this.closeTag("desc-ctxt");
                for (Motcle inferior : inferiors) {
                    this.addDesc(inferior);
                }
                this.closeTag("lhg");
            }
        }
    }

    private void addDesc(Motcle term) throws IOException {
        this.startOpenTag("desc");
        this.addAttribute("iddesc", this.getIddesc(term));
        this.closeEmptyTag();
    }

    private String getGrilleName(Motcle grid) {
        return String.valueOf(grid.getId());
    }

    private String getIdctxt(Motcle sector) {
        return String.valueOf(sector.getId());
    }

    private String getIddesc(Motcle term) {
        return String.valueOf(term.getId());
    }

    private static class ContexteInfo {
        private final String grilleName;
        private final String idctxt;

        public ContexteInfo(String grilleName, String idctxt) {
            this.grilleName = grilleName;
            this.idctxt = idctxt;
        }
    }
}

