/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.io.IOException;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.metadata.AtlasAttributeDefList;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class MetadataXMLPart
extends XMLPart {
    public MetadataXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addMetadata(AtlasMetadata atlasMetadata) throws IOException {
        this.openTag("metadata");
        Term titre = atlasMetadata.getTitre();
        this.openTag("titre");
        XMLUtils.addLibElements((XMLWriter)this, (Labels)titre.getLabels());
        AttributeUtils.addAttributes((XMLWriter)this, (Attributes)titre.getAttributes());
        this.closeTag("titre");
        this.openTag("langs");
        for (Lang lang : atlasMetadata.getWorkingLangs()) {
            this.addSimpleElement("lang", lang.toString());
        }
        this.closeTag("langs");
        this.addAttrDef(atlasMetadata.getAtlasAttributeDefList());
        AttributeUtils.addAttributes((XMLWriter)this, (Attributes)atlasMetadata.getAttributes());
        this.closeTag("metadata");
    }

    private void addAttrDef(AtlasAttributeDefList atlasAttributeDefList) throws IOException {
        String nameSpace;
        if (atlasAttributeDefList == null) {
            return;
        }
        int attrCount = atlasAttributeDefList.getAttributeDefCount();
        for (int i = 0; i < attrCount; ++i) {
            Attribute scopeAttribute;
            AttributeDef attributeDef = atlasAttributeDefList.getAttributeDef(i);
            AttributeKey key = attributeDef.getAttributeKey();
            nameSpace = key.getNameSpace();
            if (nameSpace.equals("_transient")) {
                return;
            }
            this.startOpenTag("attr-def");
            this.addAttribute("ns", nameSpace);
            this.addAttribute("key", key.getLocalKey());
            this.endOpenTag();
            String formatType = AtlasAttributes.getFormatType(attributeDef);
            if (formatType.length() > 0) {
                this.startOpenTag("format");
                this.addAttribute("type", formatType);
                this.closeEmptyTag();
            }
            if ((scopeAttribute = attributeDef.getAttributes().getAttribute(AtlasAttributes.SCOPE_KEY)) != null) {
                int scopeLength = scopeAttribute.size();
                for (int j = 0; j < scopeLength; ++j) {
                    this.addSimpleElement("scope", (String)scopeAttribute.get(j));
                }
            }
            XMLUtils.addLibElements((XMLWriter)this, (Labels)attributeDef.getTitleLabels());
            this.closeTag("attr-def");
        }
        int inactiveCount = atlasAttributeDefList.getInactiveAttributeKeyCount();
        for (int i = 0; i < inactiveCount; ++i) {
            AttributeKey attributeKey = atlasAttributeDefList.getInactiveAttributeKey(i);
            nameSpace = attributeKey.getNameSpace();
            if (nameSpace.equals("_transient")) {
                return;
            }
            this.startOpenTag("attr-def");
            this.addAttribute("ns", nameSpace);
            this.addAttribute("key", attributeKey.getLocalKey());
            this.addAttribute("active", "0");
            this.closeEmptyTag();
        }
    }
}

