/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.event.LienEvent;
import net.desmodo.atlas.event.LiensListener;
import net.desmodo.atlas.impl.LienHierarchiqueGroupImpl;
import net.desmodo.atlas.impl.LienStructurelImpl;
import net.desmodo.atlas.impl.LienSymetriqueImpl;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienExistantException;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSurLuiMemeException;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensEditor;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.InvalidContexteException;
import net.mapeadores.util.primitives.PrimUtils;

class LiensImpl
implements Liens {
    private Atlas atlas;
    private Map<Integer, ListesLiens> listsByCodeMap = new HashMap<Integer, ListesLiens>();
    private ListesLiens listesGenerales = new ListesLiens();
    private List<LiensListener> liensListeners = new ArrayList<LiensListener>();
    private Map<Long, Binome> binomeMap = new HashMap<Long, Binome>();
    private Map<Long, LienHierarchiqueGroupImpl> lienHierarchiqueGroupMap = new HashMap<Long, LienHierarchiqueGroupImpl>();
    private Map<Object, LienStructurelImpl> lienStructurelMap = new HashMap<Object, LienStructurelImpl>();

    public LiensImpl(Atlas atlas) {
        this.atlas = atlas;
    }

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    @Override
    public LienStructurelList getLienStructurelList() {
        return this.listesGenerales.getLienStructurelList();
    }

    @Override
    public LienSymetriqueList getLienSymetriqueList() {
        return this.listesGenerales.getLienSymetriqueList();
    }

    @Override
    public LienHierarchiqueGroupList getLienHierarchiqueGroupList() {
        return this.listesGenerales.getLienHierarchiqueGroupList();
    }

    @Override
    public Liens.LienLists getLienLists(Descripteur descripteur) {
        ListesLiens listeliens = this.listsByCodeMap.get(descripteur.getCode());
        if (listeliens == null) {
            return LiensUtils.EMPTY_LIENLISTS;
        }
        return listeliens;
    }

    @Override
    public LienStructurelList getLienStructurelList(Contexte contexte) {
        ListesLiens listeliens = this.listsByCodeMap.get(contexte.getCode());
        if (listeliens == null) {
            return LiensUtils.EMPTY_LIENSTRUCTUREL_LIST;
        }
        return listeliens.getLienStructurelList();
    }

    private Liens.LienLists getLienLists(int code) {
        ListesLiens listeliens = this.listsByCodeMap.get(code);
        if (listeliens == null) {
            return LiensUtils.EMPTY_LIENLISTS;
        }
        return listeliens;
    }

    @Override
    public Liens.LienLists getLienLists(Descripteur descripteur1, Descripteur descripteur2) {
        Binome desccouple = this.getBinome(descripteur1, descripteur2);
        if (desccouple == null) {
            return LiensUtils.EMPTY_LIENLISTS;
        }
        return new ListesLiens(desccouple, descripteur1.getCode());
    }

    @Override
    public void addLiensListener(LiensListener liensListener) {
        if (!this.liensListeners.contains(liensListener)) {
            this.liensListeners.add(liensListener);
        }
    }

    @Override
    public void removeLiensListener(LiensListener liensListener) {
        this.liensListeners.remove(liensListener);
    }

    @Override
    public int getLienCount(Term term) {
        ListesLiens listeliens = this.listsByCodeMap.get(term.getCode());
        if (listeliens == null) {
            return 0;
        }
        return listeliens.getLienCount();
    }

    LiensEditor getLiensEditor() {
        return new InternalLiensEditor();
    }

    void fireLienRemoved(LienHierarchique lien, int oldIndex) {
        LienEvent lienEvent = LienEvent.createLienRemovedEvent(this, lien, oldIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.lienRemoved(lienEvent);
        }
    }

    void fireLienRemoved(LienSymetrique lien) {
        LienEvent lienEvent = LienEvent.createLienRemovedEvent(this, lien);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.lienRemoved(lienEvent);
        }
    }

    void fireContexteChanged(LienSymetrique lien, int oldContexteIndex, Contexte oldContexte) {
        LienEvent lienEvent = LienEvent.createContexteChangedEvent(this, lien, oldContexteIndex, oldContexte);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.lienRemoved(lienEvent);
        }
    }

    void fireLienAdded(LienHierarchique lien, int newIndex) {
        LienEvent lienEvent = LienEvent.createLienAddedEvent(this, lien, newIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.lienAdded(lienEvent);
        }
    }

    void fireLienAdded(LienSymetrique lien) {
        LienEvent lienEvent = LienEvent.createLienAddedEvent(this, lien);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.lienAdded(lienEvent);
        }
    }

    void fireDescripteurAdded(LienStructurel lienStructurel, int newIndex) {
        LienEvent lienEvent = LienEvent.createDescripteurAddedEvent(this, lienStructurel, newIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.descripteurAdded(lienEvent);
        }
    }

    void fireDescripteurRemoved(LienStructurel lienStructurel, Descripteur descripteur, int oldIndex) {
        LienEvent lienEvent = LienEvent.createDescripteurRemovedEvent(this, lienStructurel, descripteur, oldIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.descripteurRemoved(lienEvent);
        }
    }

    void fireIndexChanged(LienStructurel lien, int oldIndex, int newIndex) {
        LienEvent lienEvent = LienEvent.createIndexChangedEvent((Liens)this, lien, oldIndex, newIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.indexChanged(lienEvent);
        }
    }

    void fireIndexChanged(LienHierarchique lien, int oldIndex, int newIndex) {
        LienEvent lienEvent = LienEvent.createIndexChangedEvent((Liens)this, lien, oldIndex, newIndex);
        for (LiensListener liensListener : this.liensListeners) {
            liensListener.indexChanged(lienEvent);
        }
    }

    void addInListesGenerales(LienHierarchique lh) {
        this.listesGenerales.addLienHierarchique(lh);
    }

    void addInListesGenerales(LienHierarchiqueGroup lhg) {
        this.listesGenerales.addLienHierarchiqueGroup(lhg);
    }

    void addInListesGenerales(LienSymetrique lsm) {
        this.listesGenerales.addLienSymetrique(lsm);
    }

    void addInListesGenerales(LienStructurel lst) {
        this.listesGenerales.addLienStructurel(lst);
    }

    void removeInListesGenerales(Lien lien) {
        this.listesGenerales.removeLien(lien);
    }

    void addInListesForTerm(LienStructurel lst, Term term) {
        this.getOrCreate(term).addLienStructurel(lst);
    }

    void addInListesForTerm(LienHierarchique lh, Term term) {
        this.getOrCreate(term).addLienHierarchique(lh);
    }

    void addInListesForTerm(LienHierarchiqueGroup lhg, Term term) {
        this.getOrCreate(term).addLienHierarchiqueGroup(lhg);
    }

    void addInListesForTerm(LienSymetrique lsm, Term term) {
        this.getOrCreate(term).addLienSymetrique(lsm);
    }

    ListesLiens getOrCreate(Term term) {
        int code = term.getCode();
        ListesLiens listes = this.listsByCodeMap.get(code);
        if (listes == null) {
            listes = new ListesLiens();
            this.listsByCodeMap.put(code, listes);
        }
        return listes;
    }

    void removeInListesForTerm(Lien lien, Term term) {
        ListesLiens listes = this.listsByCodeMap.get(term.getCode());
        if (listes != null) {
            listes.removeLien(lien);
        }
    }

    private void removeLienHierarchiqueGroup(LienHierarchiqueGroup lhg) {
        this.listesGenerales.removeLienHierarchiqueGroup(lhg);
        ListesLiens listes = this.listsByCodeMap.get(lhg.getDescripteurPere().getCode());
        listes.removeLienHierarchiqueGroup(lhg);
        ListesLiens listes2 = this.listsByCodeMap.get(lhg.getContexte().getCode());
        listes2.removeLienHierarchiqueGroup(lhg);
        this.lienHierarchiqueGroupMap.remove(LiensImpl.toLongKey(lhg.getDescripteurPere(), lhg.getContexte()));
    }

    private static Long toLongKey(Term term1, Term term2) {
        int cd2;
        int cd1 = term1.getCode();
        if (cd1 < (cd2 = term2.getCode())) {
            return PrimUtils.toLongObject((int)cd1, (int)cd2);
        }
        return PrimUtils.toLongObject((int)cd2, (int)cd1);
    }

    private Binome getBinome(Descripteur descripteur1, Descripteur descripteur2) {
        return this.binomeMap.get(LiensImpl.toLongKey(descripteur1, descripteur2));
    }

    private Binome getOrCreateBinome(Descripteur descripteur1, Descripteur descripteur2) {
        Long l = LiensImpl.toLongKey(descripteur1, descripteur2);
        Binome binome = this.binomeMap.get(l);
        if (binome == null) {
            binome = new Binome(l);
            this.binomeMap.put(l, binome);
        }
        return binome;
    }

    private LienHierarchiqueGroupImpl getLienHierarchiqueGroup(Descripteur descripteurPere, Contexte contexte) {
        return this.lienHierarchiqueGroupMap.get(LiensImpl.toLongKey(descripteurPere, contexte));
    }

    private LienHierarchiqueGroupImpl getOrCreateLienHierarchiqueGroup(Descripteur descripteurPere, Contexte contexte) {
        Long l = LiensImpl.toLongKey(descripteurPere, contexte);
        LienHierarchiqueGroupImpl lhg = this.lienHierarchiqueGroupMap.get(l);
        if (lhg == null) {
            lhg = new LienHierarchiqueGroupImpl(descripteurPere, contexte);
            this.addInListesGenerales(lhg);
            this.addInListesForTerm(lhg, (Term)descripteurPere);
            this.addInListesForTerm(lhg, (Term)contexte);
            this.lienHierarchiqueGroupMap.put(l, lhg);
        }
        return lhg;
    }

    private LienStructurelImpl getOrCreateLienStructurel(Contexte contexte1, Contexte contexte2) {
        Long l = LiensImpl.toLongKey(contexte1, contexte2);
        LienStructurelImpl lst = this.lienStructurelMap.get(l);
        if (lst == null) {
            lst = new LienStructurelImpl(contexte1, contexte2);
            this.lienStructurelMap.put(l, lst);
            this.addInListesForTerm(lst, (Term)contexte1);
            if (!contexte1.equals(contexte2)) {
                this.addInListesForTerm(lst, (Term)contexte2);
            }
            this.addInListesGenerales(lst);
        }
        return lst;
    }

    private LienStructurelImpl getLienStructurel(Contexte contexte1, Contexte contexte2) {
        return this.lienStructurelMap.get(LiensImpl.toLongKey(contexte1, contexte2));
    }

    private Binome.LhByContexte getLhByContexte(Descripteur descripteurpere, Descripteur descripteurfils, Contexte contexte) {
        Binome binome = this.getBinome(descripteurpere, descripteurfils);
        if (binome == null) {
            return null;
        }
        return binome.getLhByContexte(contexte.getCode());
    }

    private Binome.LhByContexte getOrCreateLhByContexte(Descripteur descripteurpere, Descripteur descripteurfils, Contexte contexte) {
        Binome binome = this.getOrCreateBinome(descripteurpere, descripteurfils);
        return binome.getOrCreateLhByContexte(contexte.getCode());
    }

    private class Binome {
        private long longKey;
        private LienSymetriqueImpl lienSymetrique;
        private Map<Integer, LhByContexte> lhByContexteMap = null;
        private LinkedList<LhByContexte> lhByContexteList;

        private Binome(long longKey) {
            this.longKey = longKey;
        }

        private Binome(Long longKey) {
            this((long)longKey);
        }

        private LhByContexte getLhByContexte(int codecontexte) {
            if (this.lhByContexteMap == null) {
                return null;
            }
            return this.lhByContexteMap.get(codecontexte);
        }

        private LhByContexte getOrCreateLhByContexte(int codecontexte) {
            LhByContexte lhByContexte;
            if (this.lhByContexteMap == null) {
                this.lhByContexteMap = new HashMap<Integer, LhByContexte>();
                this.lhByContexteList = new LinkedList();
            }
            if ((lhByContexte = this.lhByContexteMap.get(codecontexte)) == null) {
                lhByContexte = new LhByContexte();
                this.lhByContexteMap.put(codecontexte, lhByContexte);
                this.lhByContexteList.add(lhByContexte);
            }
            return lhByContexte;
        }

        private class LhByContexte {
            private LienHierarchiqueGroupImpl lhg1;
            private LienHierarchiqueGroupImpl lhg2;
            private LienHierarchique lh1;
            private LienHierarchique lh2;

            private LhByContexte() {
            }

            private LienHierarchiqueGroupImpl getLhg(int codedesc) {
                if (PrimUtils.equalsInt1((long)Binome.this.longKey, (int)codedesc)) {
                    return this.lhg1;
                }
                if (PrimUtils.equalsInt2((long)Binome.this.longKey, (int)codedesc)) {
                    return this.lhg2;
                }
                return null;
            }

            private LienHierarchique getLh(int codedesc) {
                if (PrimUtils.equalsInt1((long)Binome.this.longKey, (int)codedesc)) {
                    return this.lh1;
                }
                if (PrimUtils.equalsInt2((long)Binome.this.longKey, (int)codedesc)) {
                    return this.lh2;
                }
                return null;
            }

            private LienHierarchiqueGroupImpl removeLhg(int codedesc) {
                LienHierarchiqueGroupImpl lhg = null;
                if (PrimUtils.equalsInt1((long)Binome.this.longKey, (int)codedesc)) {
                    lhg = this.lhg1;
                    this.lhg1 = null;
                    this.lh2 = null;
                } else if (PrimUtils.equalsInt2((long)Binome.this.longKey, (int)codedesc)) {
                    lhg = this.lhg2;
                    this.lhg2 = null;
                    this.lh1 = null;
                }
                return lhg;
            }

            private void setLhg(int codedesc, LienHierarchiqueGroupImpl lhg, LienHierarchique lh) {
                if (PrimUtils.equalsInt1((long)Binome.this.longKey, (int)codedesc)) {
                    this.lhg1 = lhg;
                    this.lh2 = lh;
                } else if (PrimUtils.equalsInt2((long)Binome.this.longKey, (int)codedesc)) {
                    this.lhg2 = lhg;
                    this.lh1 = lh;
                }
            }
        }
    }

    private class ListesLiens
    implements Liens.LienLists {
        private MutableLienStructurelList lienStructurelList = null;
        private MutableLienHierarchiqueGroupList lienHierarchiqueGroupList = null;
        private MutableLienHierarchiqueList lienHierarchiqueList = null;
        private MutableLienSymetriqueList lienSymetriqueList = null;

        private ListesLiens() {
        }

        private ListesLiens(Binome binome, int codedesc1) {
            if (binome.lienSymetrique != null) {
                this.lienSymetriqueList = new MutableLienSymetriqueList();
                this.lienSymetriqueList.add(binome.lienSymetrique);
            }
            if (binome.lhByContexteList != null) {
                for (Binome.LhByContexte lhByContexte : binome.lhByContexteList) {
                    LienHierarchiqueGroupImpl lhg;
                    LienHierarchique lh = lhByContexte.getLh(codedesc1);
                    if (lh != null) {
                        this.addLienHierarchique(lh);
                    }
                    if ((lhg = lhByContexte.getLhg(codedesc1)) == null) continue;
                    this.addLienHierarchiqueGroup(lhg);
                }
            }
        }

        private void addLienSymetrique(LienSymetrique lien) {
            if (this.lienSymetriqueList == null) {
                this.lienSymetriqueList = new MutableLienSymetriqueList();
            }
            this.lienSymetriqueList.add(lien);
        }

        private void addLienHierarchiqueGroup(LienHierarchiqueGroup lhg) {
            if (this.lienHierarchiqueGroupList == null) {
                this.lienHierarchiqueGroupList = new MutableLienHierarchiqueGroupList();
            }
            this.lienHierarchiqueGroupList.add(lhg);
        }

        private void addLienHierarchique(LienHierarchique lien) {
            if (this.lienHierarchiqueList == null) {
                this.lienHierarchiqueList = new MutableLienHierarchiqueList();
            }
            this.lienHierarchiqueList.add(lien);
        }

        private void addLienStructurel(LienStructurel lien) {
            if (this.lienStructurelList == null) {
                this.lienStructurelList = new MutableLienStructurelList();
            }
            this.lienStructurelList.add(lien);
        }

        private void removeLienHierarchiqueGroup(LienHierarchiqueGroup lhg) {
            if (this.lienHierarchiqueGroupList != null) {
                this.lienHierarchiqueGroupList.remove(lhg);
            }
        }

        private void removeLien(Lien lien) {
            if (lien instanceof LienSymetrique) {
                this.lienSymetriqueList.remove((LienSymetrique)lien);
            } else if (lien instanceof LienHierarchique) {
                this.lienHierarchiqueList.remove((LienHierarchique)lien);
            } else if (lien instanceof LienStructurel) {
                this.lienStructurelList.remove((LienStructurel)lien);
            }
        }

        private int getLienCount() {
            int count = 0;
            if (this.lienStructurelList != null) {
                count += this.lienStructurelList.getLienStructurelCount();
            }
            if (this.lienSymetriqueList != null) {
                count += this.lienSymetriqueList.getLienSymetriqueCount();
            }
            if (this.lienHierarchiqueList != null) {
                count += this.lienHierarchiqueList.getLienHierarchiqueCount();
            }
            if (this.lienHierarchiqueGroupList != null) {
                count += this.lienHierarchiqueGroupList.getLienHierarchiqueGroupCount();
            }
            return count;
        }

        @Override
        public LienHierarchiqueList getLienHierarchiqueList() {
            if (this.lienHierarchiqueList == null) {
                return LiensUtils.EMPTY_LIENHIERARCHIQUE_LIST;
            }
            return this.lienHierarchiqueList;
        }

        @Override
        public LienSymetriqueList getLienSymetriqueList() {
            if (this.lienSymetriqueList == null) {
                return LiensUtils.EMPTY_LIENSYMETRIQUE_LIST;
            }
            return this.lienSymetriqueList;
        }

        @Override
        public LienHierarchiqueGroupList getLienHierarchiqueGroupList() {
            if (this.lienHierarchiqueGroupList == null) {
                return LiensUtils.EMPTY_LIENHIERARCHIQUEGROUP_LIST;
            }
            return this.lienHierarchiqueGroupList;
        }

        @Override
        public LienStructurelList getLienStructurelList() {
            if (this.lienStructurelList == null) {
                return LiensUtils.EMPTY_LIENSTRUCTUREL_LIST;
            }
            return this.lienStructurelList;
        }
    }

    private class InternalLiensEditor
    implements LiensEditor {
        private InternalLiensEditor() {
        }

        @Override
        public LienStructurel addDescripteur(Contexte contexte1, Contexte contexte2, Descripteur descripteur, int n) throws LienExistantException, InvalidContexteException {
            VeryLongKey vlk = new VeryLongKey(contexte1, contexte2, descripteur);
            if (LiensImpl.this.lienStructurelMap.containsKey(vlk)) {
                throw new LienExistantException();
            }
            if (!contexte1.isActive()) {
                throw new InvalidContexteException("contexte1 is not active");
            }
            if (!contexte2.isActive()) {
                throw new InvalidContexteException("contexte21 is not active");
            }
            LienStructurelImpl lienStructurel = LiensImpl.this.getOrCreateLienStructurel(contexte1, contexte2);
            lienStructurel.addDescripteur(descripteur, n);
            LiensImpl.this.lienStructurelMap.put(vlk, lienStructurel);
            LiensImpl.this.addInListesForTerm(lienStructurel, (Term)descripteur);
            LiensImpl.this.fireDescripteurAdded(lienStructurel, n);
            return lienStructurel;
        }

        @Override
        public LienStructurel setDescripteurIndex(Contexte contexte1, Contexte contexte2, Descripteur descripteur, int n) {
            LienStructurelImpl lienStructurel = LiensImpl.this.getLienStructurel(contexte1, contexte2);
            if (lienStructurel == null) {
                return null;
            }
            int ancienordre = DescripteursUtils.indexOf(lienStructurel.getDescripteurList(), descripteur);
            if (ancienordre == -1) {
                return null;
            }
            lienStructurel.setIndex(ancienordre, n);
            LiensImpl.this.fireIndexChanged(lienStructurel, ancienordre, n);
            return lienStructurel;
        }

        @Override
        public int removeDescripteur(Contexte contexte1, Contexte contexte2, Descripteur descripteur) {
            VeryLongKey vlk = new VeryLongKey(contexte1, contexte2, descripteur);
            LienStructurelImpl lienStructurel = (LienStructurelImpl)LiensImpl.this.lienStructurelMap.get(vlk);
            if (lienStructurel == null) {
                return -1;
            }
            int ordre = lienStructurel.removeDescripteur(descripteur);
            if (ordre == -1) {
                return -1;
            }
            LiensImpl.this.removeInListesForTerm(lienStructurel, descripteur);
            LiensImpl.this.lienStructurelMap.remove(vlk);
            if (lienStructurel.getDescripteurList().getDescripteurCount() == 0) {
                LiensImpl.this.lienStructurelMap.remove(LiensImpl.toLongKey(contexte1, contexte2));
                LiensImpl.this.removeInListesForTerm(lienStructurel, contexte1);
                if (!contexte1.equals(contexte2)) {
                    LiensImpl.this.removeInListesForTerm(lienStructurel, contexte2);
                }
                LiensImpl.this.removeInListesGenerales(lienStructurel);
            }
            LiensImpl.this.fireDescripteurRemoved(lienStructurel, descripteur, ordre);
            return ordre;
        }

        @Override
        public LienSymetrique createLienSymetrique(Descripteur descripteur1, Contexte contexte1, Descripteur descripteur2, Contexte contexte2) throws LienExistantException, LienSurLuiMemeException {
            Binome binome = LiensImpl.this.getOrCreateBinome(descripteur1, descripteur2);
            if (binome.lienSymetrique != null) {
                throw new LienExistantException();
            }
            LienSymetriqueImpl lsdb = new LienSymetriqueImpl(descripteur1, contexte1, descripteur2, contexte2);
            binome.lienSymetrique = lsdb;
            LiensImpl.this.addInListesGenerales(lsdb);
            LiensImpl.this.addInListesForTerm(lsdb, (Term)descripteur1);
            LiensImpl.this.addInListesForTerm(lsdb, (Term)descripteur2);
            LiensImpl.this.addInListesForTerm(lsdb, (Term)contexte1);
            if (!contexte1.equals(contexte2)) {
                LiensImpl.this.addInListesForTerm(lsdb, (Term)contexte2);
            }
            LiensImpl.this.fireLienAdded(lsdb);
            return lsdb;
        }

        @Override
        public boolean removeLienSymetrique(Descripteur descripteur1, Descripteur descripteur2) {
            Binome binome = LiensImpl.this.getBinome(descripteur1, descripteur2);
            if (binome == null || binome.lienSymetrique == null) {
                return false;
            }
            LienSymetriqueImpl lsm = binome.lienSymetrique;
            binome.lienSymetrique = null;
            LiensImpl.this.removeInListesForTerm(lsm, descripteur1);
            LiensImpl.this.removeInListesForTerm(lsm, descripteur2);
            Contexte contexte1 = lsm.getContexte(0);
            Contexte contexte2 = lsm.getContexte(1);
            LiensImpl.this.removeInListesForTerm(lsm, contexte1);
            if (!contexte1.equals(contexte2)) {
                LiensImpl.this.removeInListesForTerm(lsm, descripteur2);
            }
            LiensImpl.this.removeInListesGenerales(lsm);
            LiensImpl.this.fireLienRemoved(lsm);
            return true;
        }

        @Override
        public LienSymetrique setContexteOfLienSymetrique(Descripteur descripteur, Contexte nvcontexte, Descripteur otherdescripteur) throws LienExistantException {
            Binome binome = LiensImpl.this.getBinome(descripteur, otherdescripteur);
            if (binome == null || binome.lienSymetrique == null) {
                return null;
            }
            LienSymetriqueImpl lsm = binome.lienSymetrique;
            int index = LiensUtils.indexOf(lsm, descripteur);
            Contexte oldcontexte = lsm.getContexte(index);
            int otherindex = index == 0 ? 1 : 0;
            Contexte othercontexte = lsm.getContexte(otherindex);
            if (!othercontexte.equals(oldcontexte)) {
                LiensImpl.this.removeInListesForTerm(lsm, oldcontexte);
            }
            lsm.setContexte(index, nvcontexte);
            if (!nvcontexte.equals(othercontexte)) {
                LiensImpl.this.addInListesForTerm(lsm, (Term)nvcontexte);
            }
            LiensImpl.this.fireContexteChanged(lsm, index, oldcontexte);
            return lsm;
        }

        @Override
        public boolean removeLienHierarchique(Descripteur descripteurpere, Descripteur descripteurfils, Contexte contexte) {
            Binome.LhByContexte lhByContexte = LiensImpl.this.getLhByContexte(descripteurpere, descripteurfils, contexte);
            if (lhByContexte == null) {
                return false;
            }
            LienHierarchiqueGroupImpl lhg = lhByContexte.removeLhg(descripteurpere.getCode());
            if (lhg == null) {
                return false;
            }
            LienHierarchique lh = lhg.removeFils(descripteurfils);
            if (lh != null) {
                LiensImpl.this.removeInListesForTerm(lh, descripteurfils);
                if (lhg.getLienHierarchiqueCount() == 0) {
                    LiensImpl.this.removeLienHierarchiqueGroup(lhg);
                }
                LiensImpl.this.fireLienRemoved(lh, lh.getLienHierarchiqueIndex());
                return true;
            }
            return false;
        }

        @Override
        public LienHierarchique setLienHierarchiqueIndex(Descripteur descripteurpere, Descripteur descripteurfils, Contexte contexte, int n) {
            Binome.LhByContexte lhByContexte = LiensImpl.this.getLhByContexte(descripteurpere, descripteurfils, contexte);
            if (lhByContexte == null) {
                return null;
            }
            LienHierarchique lh = lhByContexte.getLh(descripteurfils.getCode());
            if (lh == null) {
                return null;
            }
            int oldordre = lh.getLienHierarchiqueIndex();
            LienHierarchique lh2 = ((LienHierarchiqueGroupImpl)lh.getLienHierarchiqueGroup()).setIndex(oldordre, n);
            if (lh2 != null) {
                LiensImpl.this.fireIndexChanged(lh2, oldordre, n);
            }
            return lh2 != null ? lh2 : lh;
        }

        @Override
        public LienHierarchique createLienHierarchique(Descripteur descripteurpere, Descripteur descripteurfils, Contexte contexte, int n) throws LienExistantException, LienSurLuiMemeException {
            if (descripteurfils.equals(descripteurpere)) {
                throw new LienSurLuiMemeException();
            }
            Binome.LhByContexte lhByContexte = LiensImpl.this.getOrCreateLhByContexte(descripteurpere, descripteurfils, contexte);
            if (lhByContexte.getLhg(descripteurpere.getCode()) != null) {
                throw new LienExistantException();
            }
            LienHierarchiqueGroupImpl lhg = LiensImpl.this.getOrCreateLienHierarchiqueGroup(descripteurpere, contexte);
            LienHierarchique lh = lhg.addFils(descripteurfils, n);
            LiensImpl.this.addInListesForTerm(lh, (Term)descripteurfils);
            lhByContexte.setLhg(descripteurpere.getCode(), lhg, lh);
            LiensImpl.this.fireLienAdded(lh, n);
            return lh;
        }

        @Override
        public Liens getLiens() {
            return LiensImpl.this;
        }
    }

    private static class MutableLienHierarchiqueGroupList
    implements LienHierarchiqueGroupList {
        private final List<LienHierarchiqueGroup> list = new ArrayList<LienHierarchiqueGroup>();

        private MutableLienHierarchiqueGroupList() {
        }

        @Override
        public int getLienHierarchiqueGroupCount() {
            return this.list.size();
        }

        @Override
        public LienHierarchiqueGroup getLienHierarchiqueGroup(int i) {
            return this.list.get(i);
        }

        private void remove(LienHierarchiqueGroup ls) {
            this.list.remove(ls);
        }

        private void add(LienHierarchiqueGroup ls) {
            this.list.add(ls);
        }
    }

    private static class MutableLienHierarchiqueList
    implements LienHierarchiqueList {
        private final List<LienHierarchique> list = new ArrayList<LienHierarchique>();

        private MutableLienHierarchiqueList() {
        }

        @Override
        public int getLienHierarchiqueCount() {
            return this.list.size();
        }

        @Override
        public LienHierarchique getLienHierarchique(int i) {
            return this.list.get(i);
        }

        private void remove(LienHierarchique ls) {
            this.list.remove(ls);
        }

        private void add(LienHierarchique ls) {
            this.list.add(ls);
        }
    }

    private static class MutableLienSymetriqueList
    implements LienSymetriqueList {
        private final List<LienSymetrique> list = new ArrayList<LienSymetrique>();

        private MutableLienSymetriqueList() {
        }

        @Override
        public int getLienSymetriqueCount() {
            return this.list.size();
        }

        @Override
        public LienSymetrique getLienSymetrique(int i) {
            return this.list.get(i);
        }

        private void remove(LienSymetrique ls) {
            this.list.remove(ls);
        }

        private void add(LienSymetrique ls) {
            this.list.add(ls);
        }
    }

    private static class MutableLienStructurelList
    implements LienStructurelList {
        private final List<LienStructurel> list = new ArrayList<LienStructurel>();

        private MutableLienStructurelList() {
        }

        @Override
        public int getLienStructurelCount() {
            return this.list.size();
        }

        @Override
        public LienStructurel getLienStructurel(int i) {
            return this.list.get(i);
        }

        private void remove(LienStructurel ls) {
            this.list.remove(ls);
        }

        private void add(LienStructurel ls) {
            this.list.add(ls);
        }
    }

    class VeryLongKey {
        long l;
        int i;

        VeryLongKey(Contexte ctxt1, Contexte ctxt2, Descripteur desc) {
            this.l = LiensImpl.toLongKey(ctxt1, ctxt2);
            this.i = desc.getCode();
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VeryLongKey)) {
                return false;
            }
            VeryLongKey vlk = (VeryLongKey)obj;
            return vlk.i == this.i && vlk.l == this.l;
        }
    }
}

