/* OdLib_Io - Copyright (c) 2020-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.opendocument.io.odtable;


/**
 *
 * @author Vincent Calame
 */
public class OdColumn {

    private final String styleName;
    private final StyleKey defaultStyleKey;
    private final CellStyle defaultCellStyle;

    public OdColumn(String styleName, StyleKey defaultStyleKey, CellStyle defaultCellStyle) {
        this.styleName = styleName;
        this.defaultStyleKey = defaultStyleKey;
        this.defaultCellStyle = defaultCellStyle;
    }

    public String getStyleName() {
        return styleName;
    }

    public StyleKey getDefaultStyleKey() {
        return defaultStyleKey;
    }

    public CellStyle getDefaultCellStyle() {
        return defaultCellStyle;
    }

}
