/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.selection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.RangeCondition;
import net.mapeadores.util.text.StringUtils;


/**
 *
 * @author Vincent Calame
 */
public class JunctionConditionBuilder {

    private final Set<String> modeSet = new LinkedHashSet<String>();
    private RangeCondition weightRangeCondition = null;

    public JunctionConditionBuilder() {
    }

    /**
     * Accepte la valeur _default qui est convertie en chaine vide.
     */
    public JunctionConditionBuilder addTieMode(String mode) {
        if (mode.equals("_default")) {
            mode = "";
        }
        modeSet.add(mode);
        return this;
    }

    public JunctionConditionBuilder setWeightRangeCondition(RangeCondition weightRangeCondition) {
        this.weightRangeCondition = weightRangeCondition;
        return this;
    }

    public boolean isEmpty() {
        return ((weightRangeCondition == null) && (modeSet.isEmpty()));
    }

    public JunctionCondition toJunctionCondition() {
        List<String> tieModeList;
        int size = modeSet.size();
        if (size > 0) {
            tieModeList = StringUtils.wrap(modeSet.toArray(new String[size]));
        } else {
            tieModeList = StringUtils.EMPTY_STRINGLIST;
        }
        return new InternalJunctionCondition(tieModeList, weightRangeCondition);
    }

    public static JunctionConditionBuilder init() {
        return new JunctionConditionBuilder();
    }


    private static class InternalJunctionCondition implements JunctionCondition {

        private final List<String> tieModeList;
        private final RangeCondition weightRangeCondition;

        private InternalJunctionCondition(List<String> tieModeList, RangeCondition weightRangeCondition) {
            this.tieModeList = tieModeList;
            this.weightRangeCondition = weightRangeCondition;
        }

        @Override
        public List<String> getTieModeList() {
            return tieModeList;
        }

        @Override
        public RangeCondition getWeightRangeCondition() {
            return weightRangeCondition;
        }

    }

}
