/* FichothequeLib_Tools - Copyright (c) 2007-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.parsers.junction;

import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;


/**
 *
 * @author Vincent Calame
 */
public class WeightMotcleToken {

    private final boolean idBundle;
    private int weight = 1;
    private int id;
    private CleanedString text;

    private WeightMotcleToken(int id, int weight) {
        this.id = id;
        this.weight = weight;
        this.idBundle = true;
    }

    private WeightMotcleToken(CleanedString text, int weight) {
        this.text = CleanedString.newInstance(text);
        this.weight = weight;
        this.idBundle = false;

    }

    public static WeightMotcleToken parse(String s, boolean withIdalpha, int weightFilter) {
        TieToken tieToken = TieToken.parse(s);
        String text = tieToken.getText();
        int weight;
        if (weightFilter < 1) {
            weight = tieToken.getWeight();
        } else {
            weight = weightFilter;
        }
        if (!withIdalpha) {
            try {
                int id = Integer.parseInt(text);
                return new WeightMotcleToken(id, weight);
            } catch (NumberFormatException nfe) {
            }
        }
        if (text.startsWith("=")) {
            try {
                int id = Integer.parseInt(text.substring(1).trim());
                return new WeightMotcleToken(id, weight);
            } catch (NumberFormatException nfe) {
            }
        }
        CleanedString cleanedString = CleanedString.newInstance(text);
        if (cleanedString == null) {
            return null;
        }
        return new WeightMotcleToken(cleanedString, weight);
    }

    public boolean isIdBundle() {
        return idBundle;
    }

    public int getWeight() {
        return weight;
    }

    public int getId() {
        return id;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    /**
     * Null si et seulement si isIdBundle() = true
     */
    public CleanedString getText() {
        return text;
    }

    public static Motcle getMotcle(WeightMotcleToken motcleToken, Thesaurus thesaurus, Lang lang) {
        if (motcleToken.isIdBundle()) {
            return thesaurus.getMotcleById(motcleToken.getId());
        }
        CleanedString cleanedString = motcleToken.getText();
        if (cleanedString == null) {
            return null;
        }
        String text = cleanedString.toString();
        if (thesaurus.isIdalphaType()) {
            return thesaurus.getMotcleByIdalpha(text);
        } else {
            return thesaurus.seekMotcleByLabel(text, lang);
        }
    }

}
