/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.parsers.junction;

import java.text.ParseException;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.junction.TieBuffer;
import net.mapeadores.util.annotation.Nullable;


/**
 *
 * @author Vincent Calame
 */
public class TieBufferParser {

    private TieBufferParser() {
    }

    public static TieBuffer parse(FichothequeQuestioner fichothequeQuestioner, String tokenString, short subsetCategory) throws ParseException {
        return parse(fichothequeQuestioner, tokenString, subsetCategory, null, null);
    }

    public static TieBuffer parse(FichothequeQuestioner fichothequeQuestioner, String tokenString, short subsetCategory, Subset defaultSubset, String mode) throws ParseException {
        TieToken tieToken = TieToken.parse(tokenString);
        int weight = tieToken.getWeight();
        if (mode == null) {
            mode = tieToken.getMode();
        }
        SubsetItem subsetItem = fichothequeQuestioner.parseGlobalId(tieToken.getText(), subsetCategory, defaultSubset);
        return new TieBuffer(subsetItem, mode, weight);
    }

    public static TieBuffer parseId(Subset subset, String tokenString, @Nullable String mode, int weightFilter) throws ParseException {
        TieToken tieToken = TieToken.parse(tokenString);
        int weight;
        if (weightFilter < 1) {
            weight = tieToken.getWeight();
        } else {
            weight = weightFilter;
        }
        if (mode == null) {
            mode = tieToken.getMode();
        }
        int id;
        try {
            id = Integer.parseInt(tieToken.getText());
        } catch (NumberFormatException nfe) {
            throw new ParseException(tokenString, 0);
        }
        if (id < 0) {
            throw new ParseException(tokenString, 0);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw new ParseException(tokenString, 0);
        }
        return new TieBuffer(subsetItem, mode, weight);
    }

    public static TieBuffer parseIdalpha(Thesaurus thesaurus, String tokenString, String mode, int weightFilter) throws ParseException {
        TieToken tieToken = TieToken.parse(tokenString);
        int weight;
        if (weightFilter < 1) {
            weight = tieToken.getWeight();
        } else {
            weight = weightFilter;
        }
        if (mode == null) {
            mode = tieToken.getMode();
        }
        Motcle motcle = thesaurus.getMotcleByIdalpha(tieToken.getText());
        if (motcle == null) {
            throw new ParseException(tokenString, 0);
        }
        return new TieBuffer(motcle, mode, weight);
    }

}
