/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers.corpus;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.parsers.FicheParser;


/**
 *
 * @author Vincent Calame
 */
class CreationRowParser extends EditRowParser {

    private final boolean defaultOwnersAdd;

    CreationRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        super(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
        this.defaultOwnersAdd = ((!corpusColumns.hasColumn(FieldKey.OWNERS)) && (parseContext.getDefaultOwners() != null));
    }


    @Override
    public void parseRow(int rowNumber, Row row) {
        int idIndex = corpusColumns.getIdIndex();
        int newId = -1;
        if ((idIndex != -1) && (row.getColumnCount() > idIndex)) {
            String id = row.getColumnValue(idIndex).trim();
            try {
                newId = Integer.parseInt(id);
                FicheMeta ficheMeta = corpus.getFicheMetaById(newId);
                if (ficheMeta != null) {
                    parseResultBuilder.existingId(rowNumber, id);
                    return;
                }
            } catch (NumberFormatException nfe) {
                parseResultBuilder.notIntegerId(rowNumber, id);
                return;
            }
        }
        EditFicheImportBuilder ficheImportBuilder = editCorpusImportBuilder.getEditFicheImportBuilder(newId);
        populate(ficheImportBuilder, row);
        if (defaultOwnersAdd) {
            ficheImportBuilder.getFicheChangeBuilder().appendOwners(parseContext.getDefaultOwners());
        }
        setCreationDate(ficheImportBuilder, rowNumber, row);
    }

    static CreationRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, ImportationParseContext parseContext) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, editCorpusImportBuilder, parseResultBuilder);
        return new CreationRowParser(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
    }

}
