/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.catalogs;

import net.fichotheque.format.formatters.ValueFormatter;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.mapeadores.util.text.Idalpha;


/**
 *
 * @author Vincent Calame
 */
public final class IdalphaFormatterCatalog {

    public final static ValueFormatter VALUE = (value, formatSource) -> {
        if (value == null) {
            return "";
        } else {
            return value;
        }
    };
    public final static ValueFormatter VALUE_UP = (value, formatSource) -> {
        if (value == null) {
            return "";
        } else {
            return FormatterEngineUtils.toUppercase(value, formatSource);
        }
    };
    public final static ValueFormatter SIGNIFICANT = (value, formatSource) -> {
        if (Idalpha.isSignificant(value)) {
            return value;
        } else {
            return "";
        }
    };

    private IdalphaFormatterCatalog() {

    }

}
