/* FichothequeLib_API - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque;

import java.text.ParseException;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;


/**
 *
 * @author Vincent Calame
 */
public interface FichothequeQuestioner {

    public SubsetItem parseGlobalId(String globalId, short subsetCategory, @Nullable Subset defaultSubset) throws ParseException;


    /**
     * Chaine de caractère sous la forme {nom du thésaurus}!{idalpha}. Le
     * caractère ! est utilisé pour se différencier du séparateur / qui concerne
     * un identifiant numérique.
     *
     * @param globalIdalpha
     * @return
     * @throws ParseException
     */
    public Motcle parseGlobalIdalpha(String globalIdalpha) throws ParseException;

    public Version parseVersionKey(String versionKey) throws ParseException;


    public default Redacteur getRedacteurByGlobalId(String userGlobalId) {
        try {
            return (Redacteur) parseGlobalId(userGlobalId, SubsetKey.CATEGORY_SPHERE, null);
        } catch (ParseException pe) {
            return null;
        }
    }

    public Redacteur getRedacteurByLogin(String login, @Nullable SubsetKey defaultSphereKey) throws UserLoginException;

    public default Redacteur getRedacteurByLogin(String login) throws UserLoginException {
        return getRedacteurByLogin(login, null);
    }

    public default String getUserGlobalId(String login, @Nullable SubsetKey defaultSphereKey) throws UserLoginException {
        Redacteur redacteur = getRedacteurByLogin(login, defaultSphereKey);
        return redacteur.getGlobalId();
    }

    public default String getUserGlobalId(String login) throws UserLoginException {
        return getUserGlobalId(login, null);
    }

    public default PersonCore toPersonCore(PersonItem personne) {
        String userGlobalId = personne.getRedacteurGlobalId();
        if (userGlobalId != null) {
            Redacteur redacteur = getRedacteurByGlobalId(userGlobalId);
            if (redacteur != null) {
                return redacteur.getPersonCore();
            } else {
                return PersonCoreUtils.toPersonCore(userGlobalId, "", "", false);
            }
        } else {
            return personne.getPersonCore();
        }
    }


}
