/* BdfServer_HtmlProducers - Copyright (c) 2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.htmlproducers.edition;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.interaction.Domains;
import fr.exemole.bdfserver.api.interaction.InteractionConstants;
import fr.exemole.bdfserver.api.interaction.domains.EditionDomain;
import fr.exemole.bdfserver.commands.edition.FilesUploadCommand;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.jslib.FicheJsLibs;
import fr.exemole.bdfserver.tools.filesupload.FilesUploadEngine;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlConstants;
import net.mapeadores.util.html.JsObject;


/**
 *
 * @author Vincent Calame
 */
public class FilesUploadFormHtmlProducer extends BdfServerHtmlProducer {

    private final String mode;
    private final String callKey;

    public FilesUploadFormHtmlProducer(BdfParameters bdfParameters, String mode, String callKey) {
        super(bdfParameters);
        this.mode = checkMode(mode);
        this.callKey = callKey;
        setBodyCssClass("global-body-Transparent");
        addJsLib(FicheJsLibs.FILESUPLOAD);
    }

    @Override
    public void printHtml() {
        JsObject args = JsObject.init()
                .put("step", "form")
                .put("callKey", callKey);
        String formId = generateId();
        ParameterMap parameterMap = ParameterMap.init()
                .command(FilesUploadCommand.COMMANDNAME)
                .page(EditionDomain.FILESUPLOAD_RESULT_PAGE)
                .errorPage(EditionDomain.FILESUPLOAD_FORM_PAGE)
                .param(FilesUploadCommand.MODE_PARAMNAME, mode)
                .param(InteractionConstants.CALLKEY_PARAMNAME, callKey);
        HtmlAttributes fileInput = this.name(FilesUploadCommand.FILES_PARAMNAME).type(HtmlConstants.FILE_TYPE).addClass("global-FileInput filesupload-FileInput").size("70").multiple(true);
        start();
        this
                .SCRIPT()
                .__jsObject("FilesUpload.ARGS", args)
                ._SCRIPT();
        this
                .FORM_post(HA.id(formId).action(Domains.EDITION)
                        .enctype(HtmlConstants.MULTIPART_ENCTYPE))
                .INPUT_hidden(parameterMap)
                .DIV("filesupload-Page")
                .DIV("filesupload-Header")
                .__(Button.submit("action-Upload", "_ submit.global.upload"))
                ._DIV()
                .DIV("filesupload-Body")
                .INPUT(fileInput)
                ._DIV()
                ._FORM();
        end();
    }

    private static String checkMode(String mode) {
        try {
            return FilesUploadEngine.checkMode(mode);
        } catch (IllegalArgumentException iae) {
            return FilesUploadEngine.MULTI_MODE;
        }
    }

}
