/* BdfServer - Copyright (c) 2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.filesupload;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;


/**
 *
 * @author Vincent Calame
 */
public class TmpFileGroup {

    private final String originalBasename;
    private final String normalizedBasename;
    private final SortedMap<String, TmpFileInfo> infoMap = new TreeMap<String, TmpFileInfo>();

    TmpFileGroup(TmpFileInfo firstTmpFileInfo) {
        this.originalBasename = firstTmpFileInfo.getOriginalBasename();
        this.normalizedBasename = firstTmpFileInfo.getNormalizedBasename();
        infoMap.put(firstTmpFileInfo.getExtension(), firstTmpFileInfo);
    }

    public String getOriginalBasename() {
        return originalBasename;
    }

    public String getNormalizedBasename() {
        return normalizedBasename;
    }

    public List<TmpFileInfo> getTmpFileInfoList() {
        return FilesUploadUtils.wrap(infoMap.values().toArray(new TmpFileInfo[infoMap.size()]));
    }

    void addTmpFileInfo(TmpFileInfo tmpFileInfo) {
        infoMap.put(tmpFileInfo.getExtension(), tmpFileInfo);
    }

    boolean containsExtension(String extension) {
        return infoMap.containsKey(extension);
    }

}
