/* BdfServer - Copyright (c) 2026 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.tools.filesupload;

import java.util.List;


/**
 *
 * @author Vincent Calame
 */
public abstract class FilesUploadResult {

    public abstract String getType();


    public static class Unique extends FilesUploadResult {

        private final List<TmpFileInfo> list;
        private final List<UploadError> uploadErrorList;

        Unique(List<TmpFileInfo> list, List<UploadError> uploadErrorList) {
            this.list = list;
            this.uploadErrorList = uploadErrorList;
        }

        @Override
        public String getType() {
            return "unique";
        }

        public List<TmpFileInfo> getTmpFileInfoList() {
            return list;
        }

        public List<UploadError> getUploadErrorList() {
            return uploadErrorList;
        }

    }


    public static class Multi extends FilesUploadResult {

        private final List<TmpFileGroup> groupList;
        private final List<UploadError> uploadErrorList;

        Multi(List<TmpFileGroup> groupList, List<UploadError> uploadErrorList) {
            this.groupList = groupList;
            this.uploadErrorList = uploadErrorList;
        }

        @Override
        public String getType() {
            return "multi";
        }

        public List<TmpFileGroup> getTmpFileGroupList() {
            return groupList;
        }

        public List<UploadError> getUploadErrorList() {
            return uploadErrorList;
        }

    }

}
