/* BdfServer_API - Copyright (c) 2006-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.api.session;


/**
 * Exception renvoyée en cas d'échec de l'authentification.
 *
 * @author Vincent Calame
 */
public class AuthenticationException extends Exception {


    /**
     * Erreur sur le mot de passe
     */
    public static String PASSWORD_ERROR = "_ error.wrong.authentication.password";
    /**
     * Erreur sur l'identifiant
     */
    public static String LOGIN_ERROR = "_ error.unknown.authentication.login";
    /**
     * Erreur sur la sphère
     */
    public static String SPHERE_ERROR = "_ error.wrong.authentication.sphere";
    /**
     * Rédacteur inactif
     */
    public static String INACTIVE_ERROR = "_ error.unsupported.authentication.inactive";
    /**
     * Erreur sur un paramètre manquant
     */
    public static String UNDEFINED_ERROR = "_ error.empty.authentication.undefined";
    /**
     * Erreur sur l'expiration de la session en cours
     */
    public static String EXIT_ERROR = "_ error.unsupported.authentication.exit";
    private final String errorMessageKey;

    public AuthenticationException(String errorMessageKey) {
        super(errorMessageKey);
        this.errorMessageKey = errorMessageKey;
    }

    public String getErrorMessageKey() {
        return errorMessageKey;
    }

}
