/* global Bdf,Overlay,Ficheform,$$ */

Ficheform.AddendaInclude.DocumentInfo = function (addenda, type, blockId, subsetItemId, basename) {
    this.addenda = addenda;
    this.type = type;
    this.blockId = blockId;
    this.subsetItemId = subsetItemId;
    this.isRemoved = false;
    this.basename = basename;
    this.basenameAtStart = basename;
    this.originalName = "";
    this.extensionInfoArray = [];
    this.extensionChanged = false;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.initExtensionInfo = function (extension) {
    let href = "documents/" + this.addenda + "/"  + this.basenameAtStart + "." + extension;
    this.extensionInfoArray.push(new Ficheform.AddendaInclude.ExtensionInfo(extension, href, false, null, false));
    this.sortExtensions();
};

Ficheform.AddendaInclude.DocumentInfo.prototype.completeUrl = function (url) {
    url += "&id=" + this.subsetItemId;
    if (this.hasChange()) {
        url += "&change=" + encodeURIComponent(this.convertChange());
    }
    return url;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.hasChange = function () {
    if (this.hasNameChange()) {
        return true;
    }
    if (this.extensionChanged) {
        return true;
    }
    return false;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.hasNameChange = function () {
    if (this.type === "created") {
        return true;
    }    
    return (this.basename !== this.basenameAtStart);
};

Ficheform.AddendaInclude.DocumentInfo.prototype.convertChange = function () {
    var text = "";
    for(let extensionInfo of this.extensionInfoArray) {
        if (extensionInfo.isRemoved) {
            if (!extensionInfo.isCreated) {
                text += "re=" + extensionInfo.extension + ",";
            }
        } else if (extensionInfo.tmpFileName) {
            text += "tf=" + extensionInfo.tmpFileName + ",";
        }
    }
    if (this.hasNameChange()) {
        text += "bn=" + this.basename;
    }
    return text;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.checkChangeCall = function (callResponse) {
    var addenda = this.addenda;
    if (callResponse.basename) {
        this.basename = callResponse.basename;
    }
    if (callResponse.originalName) {
        this.originalName = callResponse.originalName;
    }
    var extensionChanged = false;
    var extensionInfoArray = [];
    for(let extensionObj of callResponse.extensions) {
        let href, tmpFileName, isRemoved, isCreated;
        switch(extensionObj.state) {
            case Ficheform.AddendaInclude.UPDATE_STATE: {
                tmpFileName = extensionObj.tmpFileName;
                href = Bdf.toTmpPath(tmpFileName);
                extensionChanged = true;
                break;
            }
            case Ficheform.AddendaInclude.CREATE_STATE: {
                tmpFileName = extensionObj.tmpFileName;
                href = Bdf.toTmpPath(tmpFileName);
                isCreated = true;
                extensionChanged = true;
                break;
            }
            case Ficheform.AddendaInclude.REMOVE_STATE: {
                if (this.type === "created") {
                    continue;
                }
                isRemoved = true;
                if (extensionObj.tmpFileName) {
                    href =  Bdf.toTmpPath(extensionObj.tmpFileName);
                } else {
                    href = "documents/" + addenda + "/" + extensionObj.currentFileName;
                }
                extensionChanged = true;
                break;
            }
            default: {
                href = "documents/" + addenda + "/"  + extensionObj.currentFileName;
            }
        }
        extensionInfoArray.push(new Ficheform.AddendaInclude.ExtensionInfo(extensionObj.extension, href, tmpFileName, isRemoved, isCreated));
    }
    this.extensionChanged = extensionChanged;
    this.extensionInfoArray = extensionInfoArray;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.checkTmpFile = function (tmpFile) {
    var done = false;
    var tmpExtension = tmpFile.extension;
    for(let extensionInfo of this.extensionInfoArray) {
        if (extensionInfo.extension === tmpExtension) {
            extensionInfo.update(tmpFile);
            done = true;
        }
    }
    if (!done) {
        this.extensionInfoArray.push(new Ficheform.AddendaInclude.ExtensionInfo(tmpExtension, Bdf.toTmpPath(tmpFile.tmpFileName), tmpFile.tmpFileName, false, true));
        this.sortExtensions();
    }
    this.extensionChanged = true;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.getExtensionInfo = function (extension) {
    for(let extensionInfo of this.extensionInfoArray) {
        if (extensionInfo.extension === extension) {
            return extensionInfo;
        }
    }
    return null;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.setRemoved = function (extension, removed) {
    var extensionInfo = this.getExtensionInfo(extension);
    if (!extensionInfo) {
        return;
    }
    if (extensionInfo.isRemoved === removed) {
        return this;
    }
    extensionInfo.isRemoved = removed;
    this.extensionChanged = true;
};

Ficheform.AddendaInclude.DocumentInfo.prototype.sortExtensions = function() {
    this.extensionInfoArray.sort(function (info1, info2) {
        if (info1.extension < info2.extension) {
            return -1;
        }
        if (info1.extension > info2.extension) {
            return 1;
        }
        return 0;
    });
};

Ficheform.AddendaInclude.DocumentInfo.newCreated = function(addenda, basename) {
    return new Ficheform.AddendaInclude.DocumentInfo(addenda, "created", Bdf.generateId(), 0, basename);
};

Ficheform.AddendaInclude.ExtensionInfo = function (extension, href, tmpFileName, isRemoved, isCreated) {
    this.extension = extension;
    this.href = href;
    this.tmpFileName = tmpFileName;
    this.isRemoved = isRemoved;
    this.isCreated = isCreated;
};

Ficheform.AddendaInclude.ExtensionInfo.prototype.update = function (tmpFile) {
    this.tmpFileName = tmpFile.tmpFileName;
    this.href = Bdf.toTmpPath(tmpFile.tmpFileName);
    if (this.isRemoved) {
        this.isRemoved = false;
    }
};

Ficheform.AddendaInclude.ExtensionInfo.prototype.getCssClass = function () {
    if (this.isRemoved) {
        return "ficheform-document-VersionRemoved";
    }
    if (this.tmpFileName) {
        if (this.isCreated) {
            return "ficheform-document-VersionAdded";
        } else {
            return "ficheform-document-VersionChanged";
        }
    }
    return "";
};

