/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.text.ParseException;
import java.util.ArrayList;
import net.mapeadores.util.text.StringUtils;

public final class RelativePath
implements CharSequence {
    public static final RelativePath EMPTY = new RelativePath("");
    private final String path;

    private RelativePath(String path) {
        this.path = path;
    }

    @Override
    public char charAt(int index) {
        return this.path.charAt(index);
    }

    @Override
    public int length() {
        return this.path.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.path.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        RelativePath otherPath = (RelativePath)other;
        return otherPath.path.equals(this.path);
    }

    public String getLastName() {
        int idx = this.path.lastIndexOf(47);
        if (idx == -1) {
            return this.path;
        }
        return this.path.substring(idx + 1);
    }

    public String getParentPath() {
        int idx = this.path.lastIndexOf(47);
        if (idx == -1) {
            return "";
        }
        return this.path.substring(0, idx + 1);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public boolean hasParent() {
        return this.path.indexOf(47) != -1;
    }

    public String getPath() {
        return this.path;
    }

    public String[] toArray() {
        if (this.path.length() == 0) {
            return new String[0];
        }
        int idx = this.path.indexOf("/");
        if (idx == -1) {
            String[] result = new String[]{this.path};
            return result;
        }
        ArrayList<String> partList = new ArrayList<String>();
        partList.add(this.path.substring(0, idx));
        while (true) {
            int idx2;
            if ((idx2 = this.path.indexOf("/", idx + 1)) == -1) {
                String part = this.path.substring(idx + 1);
                if (part.length() <= 0) break;
                partList.add(part);
                break;
            }
            partList.add(this.path.substring(idx + 1, idx2));
            idx = idx2;
        }
        return partList.toArray(new String[partList.size()]);
    }

    public RelativePath buildChild(String childPath) {
        if (this.path.isEmpty()) {
            return RelativePath.build(childPath);
        }
        return RelativePath.build(this.path + "/" + childPath);
    }

    public RelativePath parseChild(String childPath) throws ParseException {
        if (this.path.isEmpty()) {
            return RelativePath.parse(childPath);
        }
        return RelativePath.parse(this.path + "/" + childPath);
    }

    public static RelativePath parse(String path) throws ParseException {
        if (path == null) {
            return EMPTY;
        }
        if ((path = path.trim()).isEmpty()) {
            return EMPTY;
        }
        String normalizedPath = StringUtils.normalizeRelativePath(path);
        if (normalizedPath == null) {
            throw new ParseException("Malformed: " + path, 0);
        }
        return new RelativePath(normalizedPath);
    }

    public static RelativePath build(String path) {
        try {
            return RelativePath.parse(path);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }
}

