/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.io.IOException;
import java.util.List;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogs;
import net.mapeadores.util.logging.SourceMessage;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class SourceLogXMLPart
extends XMLPart {
    public SourceLogXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addLogs(SourceLogs logs) throws IOException {
        this.openTag("logs");
        for (SourceLog log : logs) {
            this.addLog(log);
        }
        this.closeTag("logs");
    }

    public void addLog(SourceLog log) throws IOException {
        String name = log.getName();
        this.startOpenTag("log");
        this.addAttribute("name", name);
        this.addAttribute("uri", name);
        this.endOpenTag();
        for (SourceMessage sourceMessage : log.getSourceMessageList()) {
            this.addMessage(sourceMessage);
        }
        this.closeTag("log");
    }

    private void addMessage(SourceMessage sourceMessage) throws IOException {
        this.startOpenTag("message");
        this.addAttribute("category", sourceMessage.getCategory());
        this.addAttribute("key", sourceMessage.getMessageKey());
        List<Object> valueList = sourceMessage.getMessageValueList();
        if (valueList.isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            for (Object val : valueList) {
                this.addSimpleElement("value", val.toString());
            }
            this.closeTag("message");
        }
    }
}

