/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.instruction;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.instruction.Instructions;

public final class InstructionsParser {
    private InstructionsParser() {
    }

    public static Instructions parse(String s) {
        PartParser partParser = new PartParser();
        ArrayList partList = new ArrayList();
        int start = 0;
        while (true) {
            int result = partParser.parse(s, start);
            partParser.flush(partList);
            if (result == -1) break;
            start = result;
        }
        Instructions.Part[] array = partList.toArray(new Instructions.Part[partList.size()]);
        return new InternalInstructions(array);
    }

    private static class PartParser {
        private StringBuilder buf = new StringBuilder();
        private boolean onLiteral = true;

        private PartParser() {
        }

        private int parse(String text, int start) {
            if (this.onLiteral) {
                return this.parseLiteral(text, start);
            }
            return this.parseInstruction(text, start);
        }

        private int parseLiteral(String text, int start) {
            int length = text.length();
            for (int i = start; i < length; ++i) {
                char carac = text.charAt(i);
                if (carac == '{') {
                    return i + 1;
                }
                if (carac == '\\') {
                    if (i == length - 1) {
                        this.buf.append('\\');
                        continue;
                    }
                    char next = text.charAt(i + 1);
                    switch (next) {
                        case 'n': {
                            this.buf.append("\n");
                            break;
                        }
                        case 't': {
                            this.buf.append("\t");
                            break;
                        }
                        case 'r': {
                            this.buf.append("\r");
                            break;
                        }
                        default: {
                            this.buf.append(next);
                        }
                    }
                    ++i;
                    continue;
                }
                this.buf.append(carac);
            }
            return -1;
        }

        private int parseInstruction(String text, int start) {
            boolean onQuote = false;
            int length = text.length();
            for (int i = start; i < length; ++i) {
                char carac = text.charAt(i);
                if (onQuote) {
                    this.buf.append(carac);
                    if (carac == '\"') {
                        onQuote = false;
                        continue;
                    }
                    if (carac != '\\' || i >= length - 1) continue;
                    this.buf.append(text.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (carac == '}') {
                    return i + 1;
                }
                this.buf.append(carac);
                if (carac != '\"') continue;
                onQuote = true;
            }
            return -1;
        }

        private void flush(List<Instructions.Part> partList) {
            String text = this.buf.toString();
            boolean currentOnLiteral = this.onLiteral;
            this.onLiteral = !this.onLiteral;
            this.buf = new StringBuilder();
            if (text.length() == 0) {
                return;
            }
            if (currentOnLiteral) {
                partList.add(new InternalLiteralPart(text));
            } else {
                InternalErrorHandler errorHandler = new InternalErrorHandler();
                Instruction instruction = InstructionParser.parse(text, errorHandler);
                if (instruction != null) {
                    partList.add(new InternalInstructionPart(instruction));
                }
                if (errorHandler.hasError()) {
                    partList.add(new InternalLiteralPart(errorHandler.getErrorText()));
                }
            }
        }
    }

    private static class InternalInstructions
    extends AbstractList<Instructions.Part>
    implements Instructions {
        private final Instructions.Part[] array;

        private InternalInstructions(Instructions.Part[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Instructions.Part get(int i) {
            return this.array[i];
        }
    }

    private static class InternalInstructionPart
    implements Instructions.InstructionPart {
        private final Instruction instruction;

        private InternalInstructionPart(Instruction instruction) {
            this.instruction = instruction;
        }

        @Override
        public Instruction getInstruction() {
            return this.instruction;
        }
    }

    private static class InternalLiteralPart
    implements Instructions.LiteralPart {
        private final String text;

        private InternalLiteralPart(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class InternalErrorHandler
    implements InstructionErrorHandler {
        private final StringBuilder buf = new StringBuilder();

        private InternalErrorHandler() {
        }

        @Override
        public void invalidAsciiCharacterError(String part, int row, int col) {
            this.buf.append(" (");
            this.buf.append("invalidAscii: ");
            this.buf.append(part);
            this.buf.append(")");
        }

        @Override
        public void invalidEndCharacterError(String part, int row, int col) {
            this.buf.append(" (");
            this.buf.append("invalidEnd: ");
            this.buf.append(part);
            this.buf.append(")");
        }

        @Override
        public void invalidSeparatorCharacterError(String part, int row, int col) {
            this.buf.append(" (");
            this.buf.append("invalidSeparator: ");
            this.buf.append(part);
            this.buf.append(")");
        }

        private boolean hasError() {
            return this.buf.length() > 0;
        }

        private String getErrorText() {
            this.buf.append(" ");
            return this.buf.toString();
        }
    }
}

