/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.buildinfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import net.mapeadores.util.buildinfo.BuildInfo;

public class BuildInfoParser {
    private String version = "";
    private String repository = "";
    private LocalDate date = null;

    private BuildInfoParser() {
    }

    public static BuildInfo parse(InputStream inputStream) throws IOException {
        String ligne;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        BuildInfoParser parser = new BuildInfoParser();
        while ((ligne = reader.readLine()) != null) {
            parser.parse(ligne);
        }
        return parser.toBuildInfo();
    }

    private void parse(String s) {
        int idx = s.indexOf(58);
        if (idx == -1) {
            return;
        }
        String key = s.substring(0, idx).trim();
        if (key.length() == 0) {
            return;
        }
        key = key.toLowerCase();
        String value = s.substring(idx + 1).trim();
        if (value.length() == 0) {
            return;
        }
        if (key.equals("version")) {
            this.version = value;
        } else if (key.equals("repository")) {
            this.repository = value;
        } else if (key.equals("svn-revision")) {
            this.repository = "SVN Revision #" + value;
        } else if (key.equals("date")) {
            try {
                this.date = LocalDate.parse(value);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
    }

    private BuildInfo toBuildInfo() {
        return new InternalBuildInfo(this.version, this.repository, this.date);
    }

    private static class InternalBuildInfo
    implements BuildInfo {
        private final String version;
        private final String repository;
        private final LocalDate date;

        private InternalBuildInfo(String version, String repository, LocalDate date) {
            this.version = version;
            this.repository = repository;
            this.date = date;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getRepository() {
            return this.repository;
        }

        @Override
        public LocalDate getDate() {
            return this.date;
        }
    }
}

