/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.DefBuilder;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrases;

public class AttributeDefBuilder
extends DefBuilder {
    private final AttributeKey attributeKey;
    private final Map<String, Object> defObjectMap = new HashMap<String, Object>();

    public AttributeDefBuilder(AttributeKey attributeKey) {
        this(attributeKey, null);
    }

    public AttributeDefBuilder(AttributeKey attributeKey, Attributes initAttributes) {
        super(initAttributes);
        if (attributeKey == null) {
            throw new IllegalArgumentException("attributeKey is null");
        }
        this.attributeKey = attributeKey;
    }

    public AttributeKey getAttributeKey() {
        return this.attributeKey;
    }

    public void putDefObject(String objectName, Object object) {
        this.defObjectMap.put(objectName, object);
    }

    public AttributeDef toAttributeDef() {
        Labels titleLabels = this.toLabels();
        Attributes attributes = this.toAttributes();
        HashMap<String, Object> finalDefObjectMap = new HashMap<String, Object>(this.defObjectMap);
        Phrases phrases = this.toPhrases();
        return new InternalAttributeDef(this.attributeKey, finalDefObjectMap, phrases, titleLabels, attributes);
    }

    private static class InternalAttributeDef
    implements AttributeDef {
        private final AttributeKey attributeKey;
        private final Map<String, Object> defObjectMap;
        private final Labels titleLabels;
        private final Phrases phrases;
        private final Attributes attributes;

        private InternalAttributeDef(AttributeKey attributeKey, Map<String, Object> defObjectMap, Phrases phrases, Labels titleLabels, Attributes attributes) {
            this.attributeKey = attributeKey;
            this.defObjectMap = defObjectMap;
            this.titleLabels = titleLabels;
            this.phrases = phrases;
            this.attributes = attributes;
        }

        @Override
        public AttributeKey getAttributeKey() {
            return this.attributeKey;
        }

        @Override
        public Object getDefObject(String objectName) {
            return this.defObjectMap.get(objectName);
        }

        @Override
        public Labels getTitleLabels() {
            return this.titleLabels;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Phrases getPhrases() {
            return this.phrases;
        }
    }
}

