/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.corpus;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.corpus.CorpusColumns;
import net.fichotheque.tools.importation.parsers.corpus.EditRowParser;
import net.fichotheque.tools.parsers.FicheParser;

class CreationRowParser
extends EditRowParser {
    private final boolean defaultOwnersAdd;

    CreationRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        super(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
        this.defaultOwnersAdd = !corpusColumns.hasColumn(FieldKey.OWNERS) && parseContext.getDefaultOwners() != null;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        int idIndex = this.corpusColumns.getIdIndex();
        int newId = -1;
        if (idIndex != -1 && row.getColumnCount() > idIndex) {
            String id = row.getColumnValue(idIndex).trim();
            try {
                newId = Integer.parseInt(id);
                FicheMeta ficheMeta = this.corpus.getFicheMetaById(newId);
                if (ficheMeta != null) {
                    this.parseResultBuilder.existingId(rowNumber, id);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.notIntegerId(rowNumber, id);
                return;
            }
        }
        EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(newId);
        this.populate(ficheImportBuilder, row);
        if (this.defaultOwnersAdd) {
            ficheImportBuilder.getFicheChangeBuilder().appendOwners(this.parseContext.getDefaultOwners());
        }
        this.setCreationDate(ficheImportBuilder, rowNumber, row);
    }

    static CreationRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, ImportationParseContext parseContext) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, editCorpusImportBuilder, parseResultBuilder);
        return new CreationRowParser(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
    }
}

