/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom.revisions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class JunctionRevisionDOMReader {
    private final RootConsumer rootConsumer = new RootConsumer();

    public JunctionRevision readJunctionRevision(Element element) {
        JunctionRevision junctionRevision = new JunctionRevision();
        DOMUtils.readChildren(element, this.rootConsumer);
        this.rootConsumer.flush(junctionRevision);
        return junctionRevision;
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final Map<String, Tie> tieMap = new LinkedHashMap<String, Tie>();
        private final List<Element> attrTempList = new ArrayList<Element>();

        private RootConsumer() {
        }

        private void clear() {
            this.tieMap.clear();
            this.attrTempList.clear();
        }

        private void flush(JunctionRevision junctionRevision) {
            for (Tie tie : this.tieMap.values()) {
                junctionRevision.addTie(tie);
            }
            this.clear();
        }

        @Override
        public void accept(Element element) {
            switch (element.getTagName()) {
                case "tie": 
                case "lien": {
                    String mode = element.getAttribute("mode");
                    int weight = this.getWeight(element);
                    int position1 = this.getPosition(element, "position1");
                    int position2 = this.getPosition(element, "position2");
                    Tie tie = JunctionUtils.toTie(mode, weight, position1, position2);
                    this.tieMap.put(mode, tie);
                    break;
                }
                case "attr": {
                    this.attrTempList.add(element);
                }
            }
        }

        private int getWeight(Element element) {
            int weight = 1;
            String weightString = element.getAttribute("weight");
            if (weightString.isEmpty()) {
                weightString = element.getAttribute("poids");
            }
            if (weightString.length() > 0) {
                try {
                    weight = Integer.parseInt(weightString);
                    if (weight < 1) {
                        weight = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return weight;
        }

        private int getPosition(Element element, String attributeName) {
            int position = 0;
            String posString = element.getAttribute(attributeName);
            if (posString.length() > 0) {
                try {
                    position = Integer.parseInt(posString);
                    if (position < 0) {
                        position = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return position;
        }
    }
}

