/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.subsettree.GroupNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetTreeBuilder;
import java.text.ParseException;
import java.util.Stack;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.text.StringUtils;

public class TreeParser {
    private final SubsetTreeBuilder subsetTreeBuilder;
    private final Stack<GroupNodeBuilder> parentStack = new Stack();
    private final short category;
    private GroupNodeBuilder currentGroupNodeBuilder;

    private TreeParser(short category) {
        this.subsetTreeBuilder = new SubsetTreeBuilder(false);
        this.category = category;
    }

    public static SubsetTree parse(BdfServer bdfServer, String text, short category) {
        TreeParser treeParser = new TreeParser(category);
        String[] tokens = StringUtils.getLineTokens(text, (short)2);
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            treeParser.parseLine(tokens[i]);
        }
        treeParser.flush();
        return treeParser.subsetTreeBuilder.toSubsetTree();
    }

    private void parseLine(String token) {
        char firstChar = token.charAt(0);
        if (firstChar == '+') {
            String groupName = this.getGroupName(token);
            if (this.currentGroupNodeBuilder != null) {
                this.parentStack.add(this.currentGroupNodeBuilder);
            }
            this.currentGroupNodeBuilder = new GroupNodeBuilder(groupName, false);
        } else if (firstChar == '-') {
            if (this.currentGroupNodeBuilder != null) {
                GroupNode groupNode = this.currentGroupNodeBuilder.toGroupNode();
                if (this.parentStack.size() == 0) {
                    this.subsetTreeBuilder.addGroupNode(groupNode);
                    this.currentGroupNodeBuilder = null;
                } else {
                    this.currentGroupNodeBuilder = this.parentStack.pop();
                    this.currentGroupNodeBuilder.addGroupNode(groupNode);
                }
            }
        } else {
            int idx = token.indexOf(40);
            if (idx != -1) {
                token = token.substring(0, idx).trim();
            }
            try {
                SubsetKey subsetKey = SubsetKey.parse(token);
                if (subsetKey.getCategory() == this.category) {
                    SubsetNode subsetNode = SubsetNodeBuilder.build(subsetKey);
                    if (this.currentGroupNodeBuilder != null) {
                        this.currentGroupNodeBuilder.addSubsetNode(subsetNode);
                    } else {
                        this.subsetTreeBuilder.addSubsetNode(subsetNode);
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void flush() {
        if (this.currentGroupNodeBuilder != null) {
            while (this.currentGroupNodeBuilder != null) {
                GroupNode groupNode = this.currentGroupNodeBuilder.toGroupNode();
                if (this.parentStack.size() == 0) {
                    this.subsetTreeBuilder.addGroupNode(groupNode);
                    this.currentGroupNodeBuilder = null;
                    continue;
                }
                this.currentGroupNodeBuilder = this.parentStack.pop();
                this.currentGroupNodeBuilder.addGroupNode(groupNode);
            }
        }
    }

    private String getGroupName(String token) {
        int idx = token.indexOf(40);
        if (idx != -1) {
            token = token.substring(1, idx).trim();
        }
        int length = token.length();
        for (int i = 0; i < length; ++i) {
            char carac = token.charAt(i);
            if (carac == '+' || carac == ' ') continue;
            token = token.substring(i).trim();
            break;
        }
        if (!StringUtils.isTechnicalName(token, true)) {
            return "syntax_error";
        }
        return token;
    }
}

