/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.interaction;

import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.List;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class PropertiesParam {
    public static final String TABLEEXPORT_TYPE = "tableexport";
    public static final String SPECIAL_TYPE = "special";
    public static final String COMPONENTS_TYPE = "components";
    public static final String EMPTY_SPECIAL = "empty";
    public static final String TABLE_SPECIAL = "table";
    public static final String FORM_SPECIAL = "form";
    public static final String PHRASES_SPECIAL = "phrases";
    public static final String USERDEFAULT_SPECIAL = "userdefault";
    public static final PropertiesParam EMPTY = new PropertiesParam("special", "empty");
    public static final PropertiesParam TABLE = new PropertiesParam("special", "table");
    public static final PropertiesParam FORM = new PropertiesParam("special", "form");
    public static final PropertiesParam PHRASES = new PropertiesParam("special", "phrases");
    public static final PropertiesParam USERDEFAULT = new PropertiesParam("special", "userdefault");
    private final String type;
    private final String name;
    private final List<String> componentNameList;

    private PropertiesParam(String type, String name) {
        this.type = type;
        this.name = name;
        this.componentNameList = null;
    }

    private PropertiesParam(String type, String name, List<String> componentNameList) {
        this.type = type;
        this.name = name;
        this.componentNameList = componentNameList;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getCompleteString() {
        return this.type + ":" + this.name;
    }

    public List<String> getComponentNameList() {
        return this.componentNameList;
    }

    public boolean isTableExport() {
        return this.type.equals(TABLEEXPORT_TYPE);
    }

    public boolean isSpecial() {
        return this.type.equals(SPECIAL_TYPE);
    }

    public static PropertiesParam fromRequest(RequestMap requestMap) {
        return PropertiesParam.fromRequest(requestMap, EMPTY);
    }

    public static PropertiesParam fromRequest(RequestMap requestMap, PropertiesParam defaultPropertiesParam) {
        PropertiesParam propertiesParam = PropertiesParam.fromRequest(requestMap, "properties", TABLEEXPORT_TYPE);
        if (propertiesParam == null) {
            propertiesParam = defaultPropertiesParam;
        }
        return propertiesParam;
    }

    public static PropertiesParam fromRequest(RequestMap requestMap, String propertiesParamName, String tableExportParamName) {
        PropertiesParam propertiesParam;
        if (propertiesParamName != null && (propertiesParam = PropertiesParam.fromProperties(requestMap.getTrimedParameter(propertiesParamName))) != null) {
            return propertiesParam;
        }
        if (tableExportParamName != null && (propertiesParam = PropertiesParam.fromTableExport(requestMap.getTrimedParameter(tableExportParamName))) != null) {
            return propertiesParam;
        }
        return null;
    }

    private static PropertiesParam fromProperties(String properties) {
        int idx = properties.indexOf(":");
        if (idx > 1) {
            String type = properties.substring(0, idx);
            String value = properties.substring(idx + 1);
            switch (type) {
                case "special": {
                    switch (properties) {
                        case "empty": {
                            return EMPTY;
                        }
                        case "table": {
                            return TABLE;
                        }
                        case "form": {
                            return FORM;
                        }
                        case "phrases": {
                            return PHRASES;
                        }
                        case "userdefault": 
                        case "default": {
                            return USERDEFAULT;
                        }
                    }
                    return new PropertiesParam(SPECIAL_TYPE, value);
                }
                case "tableexport": {
                    return PropertiesParam.fromTableExport(value);
                }
                case "components": {
                    return PropertiesParam.fromComponents(value);
                }
            }
        }
        return null;
    }

    private static PropertiesParam fromTableExport(String tableExportName) {
        if (!tableExportName.isEmpty()) {
            switch (tableExportName) {
                case "_table": {
                    return TABLE;
                }
                case "_form": {
                    return FORM;
                }
                case "_default": 
                case "_userdefault": {
                    return USERDEFAULT;
                }
            }
            return new PropertiesParam(TABLEEXPORT_TYPE, tableExportName);
        }
        return null;
    }

    private static PropertiesParam fromComponents(String componentsString) {
        String[] tokens;
        LinkedHashSet<String> componentNameSet = new LinkedHashSet<String>();
        for (String token : tokens = StringUtils.getTechnicalTokens(componentsString, true)) {
            try {
                FieldKey fieldKey = FieldKey.parse(token);
                token = fieldKey.getKeyString();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            componentNameSet.add(token);
        }
        return new PropertiesParam(COMPONENTS_TYPE, componentsString, StringUtils.toList(componentNameSet));
    }
}

