/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.api.roles.SphereSupervisor;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;

public class PermissionChecker {
    private final BdfParameters bdfParameters;
    private final PermissionSummary permissionSummary;

    public PermissionChecker(BdfParameters bdfParameters) {
        this.bdfParameters = bdfParameters;
        this.permissionSummary = bdfParameters.getPermissionSummary();
    }

    public PermissionChecker checkFichothequeAdmin() throws PermissionException {
        if (!this.bdfParameters.isFichothequeAdmin()) {
            throw BdfErrors.permission("_ error.permission.admin", new Object[0]);
        }
        return this;
    }

    public PermissionChecker checkAdmin(String ... actionNames) throws PermissionException {
        if (actionNames != null) {
            for (String actionName : actionNames) {
                if (this.permissionSummary.canDo(actionName)) continue;
                throw BdfErrors.permission("_ error.permission.admin", new Object[0]);
            }
        }
        return this;
    }

    public PermissionChecker checkHistory(Subset subset, int id) throws PermissionException {
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem != null && subsetItem instanceof FicheMeta) {
            this.checkRead((FicheMeta)subsetItem);
        } else {
            this.checkSubsetAdmin(subset);
        }
        return this;
    }

    public PermissionChecker checkSubsetAdmin(Subset subset) throws PermissionException {
        if (!this.permissionSummary.isSubsetAdmin(subset.getSubsetKey())) {
            throw BdfErrors.permission("_ error.permission.admin", new Object[0]);
        }
        return this;
    }

    public PermissionChecker checkSubsetAccess(Subset subset) throws PermissionException {
        if (!this.permissionSummary.hasAccess(subset)) {
            throw BdfErrors.permission("_ error.permission.read", subset.getSubsetKeyString());
        }
        return this;
    }

    public PermissionChecker checkWrite(SubsetItem subsetItem) throws PermissionException {
        if (!this.permissionSummary.canWrite(subsetItem)) {
            throw BdfErrors.permission("_ error.permission.write", subsetItem.getGlobalId());
        }
        return this;
    }

    public PermissionChecker checkRead(SubsetItem subsetItem) throws PermissionException {
        if (!this.permissionSummary.canRead(subsetItem)) {
            String l10nKey = subsetItem instanceof FicheMeta ? "_ error.permission.readfiche" : "_ error.permission.read";
            throw BdfErrors.permission(l10nKey, subsetItem.getGlobalId());
        }
        return this;
    }

    public PermissionChecker checkFicheCreate(Corpus corpus) throws PermissionException {
        SubsetKey subsetKey = corpus.getSubsetKey();
        if (!this.permissionSummary.canCreate(subsetKey)) {
            throw BdfErrors.permission("_ error.permission.createfiche", subsetKey.getKeyString());
        }
        return this;
    }

    public PermissionChecker checkSphereSupervisor(String sphereName) throws PermissionException {
        SphereSupervisor sphereSupervisor = (SphereSupervisor)this.bdfParameters.getBdfServer().getContextObject("sphereSupervisor");
        if (sphereSupervisor != null && !sphereSupervisor.allowCoreChange(this.bdfParameters.getBdfUser(), sphereName)) {
            throw BdfErrors.permission("_ error.permission.spheresupervisor", new Object[0]);
        }
        return this;
    }

    public static PermissionChecker init(BdfParameters bdfParameters) {
        return new PermissionChecker(bdfParameters);
    }
}

