/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfCommand;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.BdfCommandResultBuilder;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;

public abstract class AbstractBdfCommand
implements BdfCommand,
BdfInstructionConstants {
    private static final CommandMessage TEST_DONE_MESSAGE = LogUtils.done("_ done.global.test", new Object[0]);
    private final RequestMap requestMap;
    protected final BdfServer bdfServer;
    protected final Fichotheque fichotheque;
    protected BdfUser bdfUser;
    protected RequestHandler requestHandler;
    private CommandMessage commandMessage;
    private BdfCommandResultBuilder commandResultBuilder;

    public AbstractBdfCommand(BdfServer bdfServer, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
        this.fichotheque = bdfServer.getFichotheque();
    }

    @Override
    public CommandMessage testCommand(BdfUser bdfUser) {
        this.bdfUser = bdfUser;
        this.requestHandler = new RequestHandler(this.bdfServer, bdfUser, this.requestMap);
        try {
            this.checkParameters();
            return TEST_DONE_MESSAGE;
        }
        catch (ErrorMessageException eme) {
            return eme.getErrorMessage();
        }
    }

    @Override
    public BdfCommandResult doCommand(BdfUser bdfUser) {
        this.bdfUser = bdfUser;
        this.requestHandler = new RequestHandler(this.bdfServer, bdfUser, this.requestMap);
        this.commandMessage = null;
        this.commandResultBuilder = new BdfCommandResultBuilder();
        boolean canDo = false;
        try {
            this.checkParameters();
            canDo = true;
        }
        catch (ErrorMessageException eme) {
            this.commandMessage = eme.getErrorMessage();
        }
        if (canDo) {
            try {
                this.doCommand();
            }
            catch (ErrorMessageException eme) {
                this.commandMessage = eme.getErrorMessage();
            }
        }
        if (this.commandMessage != null) {
            this.commandResultBuilder.setCommandMessage(this.commandMessage);
        }
        return this.commandResultBuilder.toBdfCommandResult();
    }

    public PermissionChecker getPermissionChecker() {
        return this.requestHandler.getPermissionChecker();
    }

    public void checkFichothequeAdmin() throws PermissionException {
        this.requestHandler.getPermissionChecker().checkFichothequeAdmin();
    }

    public void checkSubsetAdmin(Subset subset) throws PermissionException {
        this.requestHandler.getPermissionChecker().checkSubsetAdmin(subset);
    }

    public String getMandatory(String paramName) throws ErrorMessageException {
        return this.requestHandler.getMandatoryParameter(paramName);
    }

    public boolean checkConfirmation() {
        return BdfInstructionUtils.checkConfirmation(this.requestMap, this.bdfServer);
    }

    protected abstract void checkParameters() throws ErrorMessageException;

    protected abstract void doCommand() throws ErrorMessageException;

    protected void putResultObject(String name, Object obj) {
        if (this.commandResultBuilder != null) {
            this.commandResultBuilder.putResultObject(name, obj);
        }
    }

    protected void setDone(String doneMessageKey, Object ... messageValues) {
        this.commandMessage = CommandMessageBuilder.init().setDone(doneMessageKey, messageValues).toCommandMessage();
    }

    protected void setCommandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
    }

    protected EditSession startEditSession(String domain, String commandName) {
        return this.startEditSession(domain + "/" + commandName);
    }

    protected EditSession startEditSession(String source) {
        if (this.bdfUser != null) {
            return this.bdfServer.initEditSession(this.bdfUser, source);
        }
        return this.bdfServer.initEditSession(EditOriginUtils.newEditOrigin(source));
    }
}

