/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.filesupload;

import fr.exemole.bdfserver.tools.filesupload.FilesUploadUtils;
import fr.exemole.bdfserver.tools.filesupload.TmpFileInfo;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class TmpFileGroup {
    private final String originalBasename;
    private final String normalizedBasename;
    private final SortedMap<String, TmpFileInfo> infoMap = new TreeMap<String, TmpFileInfo>();

    TmpFileGroup(TmpFileInfo firstTmpFileInfo) {
        this.originalBasename = firstTmpFileInfo.getOriginalBasename();
        this.normalizedBasename = firstTmpFileInfo.getNormalizedBasename();
        this.infoMap.put(firstTmpFileInfo.getExtension(), firstTmpFileInfo);
    }

    public String getOriginalBasename() {
        return this.originalBasename;
    }

    public String getNormalizedBasename() {
        return this.normalizedBasename;
    }

    public List<TmpFileInfo> getTmpFileInfoList() {
        return FilesUploadUtils.wrap(this.infoMap.values().toArray(new TmpFileInfo[this.infoMap.size()]));
    }

    void addTmpFileInfo(TmpFileInfo tmpFileInfo) {
        this.infoMap.put(tmpFileInfo.getExtension(), tmpFileInfo);
    }

    boolean containsExtension(String extension) {
        return this.infoMap.containsKey(extension);
    }
}

