/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetItem;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.syntax.FormSyntax;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.SeparatorOptions;

public class FicheFormParametersBuilder {
    public static final String PARAM_PREFIX = "param_";
    public static final String DEFVAL_PREFIX = "defval-";
    private final BdfServer bdfServer;
    private final PermissionSummary permissionSummary;
    private final FormSyntax.Parameters ficheItemFormSyntaxParameters;
    private final FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters;
    private final Map<String, String> supplementaryParameterMap = new HashMap<String, String>();
    private final Map<String, String> customDefaultValueMap = new HashMap<String, String>();
    private UserLangContext userLangContext;
    private SubsetItem masterSubsetItem;
    private Redacteur defaultRedacteur;
    private SeparatorOptions inlineSeparatorOptions = FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS;
    private SeparatorOptions blockSeparatorOptions = FormSyntax.DEFAULT_BLOCK_SEPARATOROPTIONS;
    private boolean duplicate = false;

    private FicheFormParametersBuilder(BdfServer bdfServer, UserLangContext userLangContext, PermissionSummary permissionSummary, FormSyntax.Parameters ficheItemFormSyntaxParameters, FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters) {
        this.bdfServer = bdfServer;
        this.userLangContext = userLangContext;
        this.permissionSummary = permissionSummary;
        this.ficheItemFormSyntaxParameters = ficheItemFormSyntaxParameters;
        this.ficheBlockFormSyntaxParameters = ficheBlockFormSyntaxParameters;
    }

    public FicheFormParametersBuilder setUserLangContext(UserLangContext userLangContext) {
        if (userLangContext == null) {
            throw new IllegalArgumentException("userLangContext is null");
        }
        this.userLangContext = userLangContext;
        this.ficheItemFormSyntaxParameters.decimalChar(new DecimalFormatSymbols(userLangContext.getFormatLocale()).getDecimalSeparator());
        return this;
    }

    public FicheFormParametersBuilder setDefaultRedacteur(Redacteur defaultRedacteur) {
        this.defaultRedacteur = defaultRedacteur;
        return this;
    }

    public FicheFormParametersBuilder setInlineSeparatorOptions(SeparatorOptions inlineSeparatorOptions) {
        this.inlineSeparatorOptions = inlineSeparatorOptions == null ? FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS : inlineSeparatorOptions;
        return this;
    }

    public FicheFormParametersBuilder setBlockSeparatorOptions(SeparatorOptions blockSeparatorOptions) {
        this.blockSeparatorOptions = blockSeparatorOptions == null ? FormSyntax.DEFAULT_BLOCK_SEPARATOROPTIONS : blockSeparatorOptions;
        return this;
    }

    public FicheFormParametersBuilder setWithSpecialParseChars(boolean withSpecialParseChars) {
        this.ficheBlockFormSyntaxParameters.withSpecialParseChars(withSpecialParseChars);
        return this;
    }

    public FicheFormParametersBuilder setMasterSubsetItem(SubsetItem masterSubsetItem) {
        this.masterSubsetItem = masterSubsetItem;
        return this;
    }

    public FicheFormParametersBuilder populateFromRequest(RequestMap requestMap) {
        for (String name : requestMap.getParameterNameSet()) {
            if (name.startsWith(PARAM_PREFIX)) {
                String subname = name.substring(PARAM_PREFIX.length());
                String value = requestMap.getParameter(name);
                this.supplementaryParameterMap.put(subname, value);
                continue;
            }
            if (!name.startsWith(DEFVAL_PREFIX)) continue;
            String componentName = name.substring(DEFVAL_PREFIX.length());
            String defaultValue = requestMap.getParameter(name);
            this.customDefaultValueMap.put(componentName, defaultValue);
        }
        return this;
    }

    public FicheFormParametersBuilder setCustomDefaultValue(String componentName, String defaultValue) {
        this.customDefaultValueMap.put(componentName, defaultValue);
        return this;
    }

    public FicheFormParametersBuilder setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
        return this;
    }

    public static FicheFormParametersBuilder build(BdfParameters bdfParameters) {
        return FicheFormParametersBuilder.build(bdfParameters.getBdfServer(), bdfParameters.getBdfUser(), bdfParameters.getPermissionSummary());
    }

    public static FicheFormParametersBuilder build(BdfServer bdfServer, BdfUser bdfUser) {
        return FicheFormParametersBuilder.build(bdfServer, bdfUser, PermissionSummaryBuilder.build(bdfServer, bdfUser));
    }

    public static FicheFormParametersBuilder build(BdfServer bdfServer, BdfUser bdfUser, PermissionSummary permissionSummary) {
        FormSyntax.Parameters ficheItemFormSyntaxParameters = FormSyntax.parameters().defautSphereKey(bdfUser.getRedacteur().getSubsetKey()).decimalChar(new DecimalFormatSymbols(bdfUser.getFormatLocale()).getDecimalSeparator());
        FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters = FicheblockSyntax.parameters().withSpecialParseChars(true);
        FicheFormParametersBuilder ficheFormParametersBuilder = new FicheFormParametersBuilder(bdfServer, bdfUser, permissionSummary, ficheItemFormSyntaxParameters, ficheBlockFormSyntaxParameters);
        return ficheFormParametersBuilder.setDefaultRedacteur(bdfUser.getRedacteur());
    }

    public FicheFormParameters toFicheFormParameters() {
        return new InternalFicheFormParameters(this.bdfServer, this.userLangContext, this.permissionSummary, this.ficheItemFormSyntaxParameters, this.ficheBlockFormSyntaxParameters, this.supplementaryParameterMap, this.customDefaultValueMap, this.masterSubsetItem, this.defaultRedacteur, this.inlineSeparatorOptions, this.blockSeparatorOptions, this.duplicate);
    }

    private static class InternalFicheFormParameters
    implements FicheFormParameters {
        private final BdfServer bdfServer;
        private final PermissionSummary permissionSummary;
        private final FormSyntax.Parameters ficheItemFormSyntaxParameters;
        private final FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters;
        private final Map<String, String> supplementaryParameterMap;
        private final Map<String, String> customDefaultValueMap;
        private final UserLangContext userLangContext;
        private final SubsetItem masterSubsetItem;
        private final Redacteur defaultRedacteur;
        private final SeparatorOptions inlineSeparatorOptions;
        private final SeparatorOptions blockSeparatorOptions;
        private final boolean duplicate;

        private InternalFicheFormParameters(BdfServer bdfServer, UserLangContext userLangContext, PermissionSummary permissionSummary, FormSyntax.Parameters ficheItemFormSyntaxParameters, FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters, Map<String, String> supplementaryParameterMap, Map<String, String> customDefaultValueMap, SubsetItem masterSubsetItem, Redacteur defaultRedacteur, SeparatorOptions inlineSeparatorOptions, SeparatorOptions blockSeparatorOptions, boolean duplicate) {
            this.bdfServer = bdfServer;
            this.userLangContext = userLangContext;
            this.permissionSummary = permissionSummary;
            this.ficheItemFormSyntaxParameters = ficheItemFormSyntaxParameters;
            this.ficheBlockFormSyntaxParameters = ficheBlockFormSyntaxParameters;
            this.supplementaryParameterMap = supplementaryParameterMap;
            this.customDefaultValueMap = customDefaultValueMap;
            this.masterSubsetItem = masterSubsetItem;
            this.defaultRedacteur = defaultRedacteur;
            this.inlineSeparatorOptions = inlineSeparatorOptions;
            this.blockSeparatorOptions = blockSeparatorOptions;
            this.duplicate = duplicate;
        }

        @Override
        public BdfServer getBdfServer() {
            return this.bdfServer;
        }

        @Override
        public PermissionSummary getPermissionSummary() {
            return this.permissionSummary;
        }

        @Override
        public UserLangContext getUserLangContext() {
            return this.userLangContext;
        }

        @Override
        public String getSupplementaryParameter(String name) {
            return this.supplementaryParameterMap.get(name);
        }

        @Override
        public String getCustomDefaultValue(String componentName) {
            return this.customDefaultValueMap.get(componentName);
        }

        @Override
        public FormSyntax.Parameters getFicheItemFormSyntaxParameters() {
            return this.ficheItemFormSyntaxParameters;
        }

        @Override
        public FicheblockSyntax.Parameters getFicheBlockFormSyntaxParameters() {
            return this.ficheBlockFormSyntaxParameters;
        }

        @Override
        public Redacteur getDefaultRedacteur() {
            return this.defaultRedacteur;
        }

        @Override
        public SeparatorOptions getBlockSeparatorOptions() {
            return this.blockSeparatorOptions;
        }

        @Override
        public SubsetItem getMasterSubsetItem() {
            return this.masterSubsetItem;
        }

        @Override
        public SeparatorOptions getInlineSeparatorOptions() {
            return this.inlineSeparatorOptions;
        }

        @Override
        public boolean isDuplicate() {
            return this.duplicate;
        }
    }
}

