/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine.runners;

import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.mapeadores.util.io.FileUtils;

public class AbstractOutputRunner {
    protected HashSet<String> pathDoneSet = new HashSet();
    protected boolean cleanBefore = false;
    protected BalayageLog balayageLog;
    protected BalayageParameters balayageParameters;
    protected int balayageUnitIndex;
    protected int outputIndex;
    protected BalayageOutput output;
    protected boolean isValid = true;
    protected File rootDirectory;

    public AbstractOutputRunner(BalayageParameters balayageParameters, int outputIndex, BalayageOutput output, int balayageUnitIndex) {
        this.balayageParameters = balayageParameters;
        this.cleanBefore = output.isCleanBefore();
        this.balayageLog = balayageParameters.getBalayageLog();
        this.outputIndex = outputIndex;
        this.output = output;
        this.rootDirectory = output.isIncludeOutput() ? ConfigurationUtils.getBalayageIncludeDirectory(balayageParameters.getBdfServer()) : balayageParameters.getBalayageRootDirectory();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void dispose() {
        this.pathDoneSet.clear();
        this.pathDoneSet = null;
        this.balayageLog = null;
        this.balayageParameters = null;
        this.output = null;
        this.rootDirectory = null;
    }

    protected void prepareDirectory(File directory) {
        String path = directory.getPath();
        if (this.pathDoneSet.contains(path)) {
            return;
        }
        this.pathDoneSet.add(path);
        try {
            directory.mkdirs();
        }
        catch (Exception e) {
            this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "outputPathException", path, e.getMessage());
            this.isValid = false;
        }
        if (!this.cleanBefore || this.balayageParameters.getBalayageMode() != null) {
            return;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) continue;
            try {
                FileUtils.forceDelete(file);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                String msg = ioe.getMessage();
                String message = ioe.getClass().getName();
                if (msg != null) {
                    message = message + " : " + msg;
                }
                this.balayageLog.addOutputError(this.balayageUnitIndex, this.outputIndex, this.output, "ioException", directory.getName(), message);
            }
        }
    }
}

