/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.tools.subsettree.GroupNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetNodeBuilder;
import fr.exemole.bdfserver.tools.subsettree.SubsetTreeBuilder;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TreesDOMReader {
    private final MessageHandler messageHandler;
    private BdfServerEditor bdfServerEditor;

    public TreesDOMReader(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void readTrees(BdfServerEditor bdfServerEditor, Element element_xml) {
        Element element;
        String tagName;
        int i;
        this.bdfServerEditor = bdfServerEditor;
        NodeList liste = element_xml.getChildNodes();
        int length = liste.getLength();
        for (i = 0; i < length; ++i) {
            if (liste.item(i).getNodeType() != 1 || !(tagName = (element = (Element)liste.item(i)).getTagName()).equals("metadata")) continue;
            this.readMetadata(element);
        }
        for (i = 0; i < length; ++i) {
            if (liste.item(i).getNodeType() != 1 || (tagName = (element = (Element)liste.item(i)).getTagName()).equals("metadata")) continue;
            if (tagName.equals("tree")) {
                String typeString = element.getAttribute("type");
                if (typeString.length() == 0) {
                    DomMessages.emptyAttribute(this.messageHandler, "tree", "type");
                    continue;
                }
                try {
                    short subsetCategory = TreesDOMReader.toSubsetCategory(typeString);
                    SubsetTreeBuilder subsetTreeBuilder = new SubsetTreeBuilder(false);
                    this.readTree(subsetTreeBuilder, element);
                    bdfServerEditor.setSubsetTree(subsetCategory, subsetTreeBuilder.toSubsetTree());
                }
                catch (IllegalArgumentException iae) {
                    DomMessages.wrongAttributeValue(this.messageHandler, "tree", "type", typeString);
                }
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private void readMetadata(Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("group-def")) {
                this.readGroupDef(element);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private void readGroupDef(Element element_xml) {
        String name = element_xml.getAttribute("name");
        if (name.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, "group-def", "name");
            return;
        }
        name = this.checkName(name);
        GroupDef groupDef = this.bdfServerEditor.createGroupDef(name);
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label == null) continue;
                    this.bdfServerEditor.putLabel(groupDef, label);
                }
                catch (ParseException ile) {
                    DomMessages.wrongLangAttribute(this.messageHandler, "lib", element.getAttribute("xml:lang"));
                }
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private void readTree(SubsetTreeBuilder subsetTreeBuilder, Element element_xml) {
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("group")) {
                GroupNode groupNode = this.readGroup(element);
                if (groupNode == null) continue;
                subsetTreeBuilder.addGroupNode(groupNode);
                continue;
            }
            if (tagName.equals("subset")) {
                SubsetNode subsetNode = this.readSubset(element);
                if (subsetNode == null) continue;
                subsetTreeBuilder.addSubsetNode(subsetNode);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
    }

    private GroupNode readGroup(Element element_xml) {
        String groupName = element_xml.getAttribute("name");
        if (groupName.length() == 0) {
            return null;
        }
        groupName = this.checkName(groupName);
        GroupNodeBuilder groupNodeBuilder = new GroupNodeBuilder(groupName, false);
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagName = element.getTagName();
            if (tagName.equals("subset")) {
                SubsetNode subsetNode = this.readSubset(element);
                if (subsetNode == null) continue;
                groupNodeBuilder.addSubsetNode(subsetNode);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagName);
        }
        return groupNodeBuilder.toGroupNode();
    }

    private SubsetNode readSubset(Element element_xml) {
        String xpath = "subset";
        String subsetKeyString = XMLUtils.getData(element_xml);
        if (subsetKeyString.length() == 0) {
            DomMessages.emptyElement(this.messageHandler, xpath);
            return null;
        }
        try {
            SubsetKey subsetKey = SubsetKey.parse(subsetKeyString);
            return SubsetNodeBuilder.build(subsetKey);
        }
        catch (ParseException pe) {
            DomMessages.wrongElementValue(this.messageHandler, xpath, subsetKeyString);
            return null;
        }
    }

    private String checkName(String name) {
        try {
            int i = Integer.parseInt(name);
            return "grp" + i;
        }
        catch (NumberFormatException nfe) {
            return name;
        }
    }

    private static short toSubsetCategory(String typeString) {
        if (typeString.equals("grpcorpus")) {
            return 1;
        }
        if (typeString.equals("grpthesaurus")) {
            return 2;
        }
        if (typeString.equals("grpsphere")) {
            return 3;
        }
        if (typeString.equals("grpalbum")) {
            return 5;
        }
        throw new IllegalArgumentException("wrong typeString value : " + typeString);
    }
}

