/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OldFicheDOMReader {
    private final Fichotheque fichotheque;
    private final HtmlCleaner htmlCleaner;
    private Fiche currentFiche;
    private boolean allowFlat = false;
    private final RootConsumer rootConsumer = new RootConsumer();
    private final EnteteConsumer enteteConsumer = new EnteteConsumer();
    private boolean append = true;
    private final CorpsdeficheConsumer corpsdeficheConsumer = new CorpsdeficheConsumer();

    public OldFicheDOMReader(Fichotheque fichotheque, HtmlCleaner htmlCleaner) {
        this.fichotheque = fichotheque;
        this.htmlCleaner = htmlCleaner;
    }

    public void setAllowFlat(boolean allowFlat) {
        this.allowFlat = allowFlat;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public Fiche readFiche(Element element) {
        Fiche fiche = new Fiche();
        try {
            Lang lang = Lang.parse(element.getAttribute("xml:lang"));
            fiche.setLang(lang);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.readFiche(fiche, element);
        return fiche;
    }

    public void readFiche(Fiche fiche, Element element) {
        this.currentFiche = fiche;
        DOMUtils.readChildren(element, this.rootConsumer);
    }

    public void readProp(Fiche fiche, Element element) {
        FieldKey fieldKey;
        String type = element.getAttribute("type");
        if (type.length() == 0) {
            return;
        }
        try {
            fieldKey = FieldKey.parse((short)1, type);
        }
        catch (ParseException pe) {
            return;
        }
        FicheItem ficheItem = null;
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            if (liste.item(j).getNodeType() != 1) continue;
            Element el = (Element)liste.item(j);
            ficheItem = this.readFicheItem(el);
            break;
        }
        fiche.setProp(fieldKey, ficheItem);
    }

    public void readInfo(Fiche fiche, Element element) {
        FieldKey fieldKey;
        String type = element.getAttribute("type");
        if (type.length() == 0) {
            return;
        }
        try {
            fieldKey = FieldKey.parse((short)2, type);
        }
        catch (ParseException pe) {
            return;
        }
        FicheItems ficheItems = this.readFicheItems(element);
        if (this.append) {
            fiche.appendInfo(fieldKey, ficheItems);
        } else {
            fiche.setInfo(fieldKey, ficheItems);
        }
    }

    public void readOwners(Fiche fiche, Element element) {
        FicheItems ficheItems = this.readFicheItems(element);
        if (this.append) {
            fiche.appendOwners(ficheItems);
        } else {
            fiche.setOwners(ficheItems);
        }
    }

    public FicheItem readFicheItem(Element element) {
        FicheItem ficheItem = null;
        String tagname = element.getTagName();
        if (tagname.equals("item")) {
            String value = XMLUtils.getData(element);
            if (value.length() == 0) {
                return null;
            }
            return new Item(value);
        }
        if (tagname.equals("personne")) {
            ficheItem = this.readPerson(element);
        } else if (tagname.equals("langue")) {
            ficheItem = this.readLanguage(element);
        } else if (tagname.equals("pays")) {
            ficheItem = this.readCountry(element);
        } else if (tagname.equals("datation")) {
            ficheItem = this.readDate(element);
        } else if (tagname.equals("link")) {
            ficheItem = this.readLink(element);
        } else if (tagname.equals("courriel")) {
            ficheItem = this.readEmail(element);
        } else if (tagname.equals("entite")) {
            ficheItem = this.readEntite(element);
        } else if (tagname.equals("biblio")) {
            ficheItem = this.readBiblio(element);
        } else if (tagname.equals("montant")) {
            ficheItem = this.readAmount(element);
        } else if (tagname.equals("nombre")) {
            ficheItem = this.readNumber(element);
        } else if (tagname.equals("geopoint")) {
            ficheItem = this.readGeopoint(element);
        } else if (tagname.equals("para")) {
            ficheItem = this.readPara(element);
        } else if (tagname.equals("image")) {
            ficheItem = this.readImage(element);
        }
        return ficheItem;
    }

    private FicheItem readRedacteur(String sphereString, String login) {
        block5: {
            try {
                SubsetKey subsetKey = SubsetKey.parse((short)3, sphereString);
                Sphere sphere = (Sphere)this.fichotheque.getSubset(subsetKey);
                if (sphere == null) break block5;
                try {
                    Redacteur redacteur = sphere.getRedacteurByLogin(login);
                    if (redacteur != null) {
                        return new PersonItem(redacteur.getGlobalId());
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Item(login + "[" + sphereString + "]");
    }

    public FicheItem readPerson(Element element_xml) {
        String login = element_xml.getAttribute("idsphere");
        String sphereString = element_xml.getAttribute("sphere");
        if (sphereString.length() != 0 && login.length() != 0) {
            return this.readRedacteur(sphereString, login);
        }
        String nom = "";
        String prenom = "";
        String organisme = "";
        String original = "";
        NodeList liste = element_xml.getChildNodes();
        boolean nomAvant = false;
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element el = (Element)liste.item(i);
            String tagname = el.getTagName();
            if (tagname.equals("nom")) {
                String strg_style;
                nom = XMLUtils.getData(el);
                String avantString = el.getAttribute("avant");
                if (avantString.equals("true")) {
                    nomAvant = true;
                }
                if (!(strg_style = el.getAttribute("style")).equals("zh") && !strg_style.equals("zh-latin")) continue;
                nomAvant = true;
                continue;
            }
            if (tagname.equals("prenom")) {
                prenom = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("original")) {
                original = XMLUtils.getData(el);
                continue;
            }
            if (!tagname.equals("organisme")) continue;
            organisme = XMLUtils.getData(el);
        }
        PersonCore personCore = PersonCoreUtils.toPersonCore(nom, prenom, original, nomAvant);
        return new PersonItem(personCore, organisme);
    }

    public LanguageItem readLanguage(Element element_xml) {
        String strg_intlang = element_xml.getAttribute("lang");
        try {
            Lang lang = Lang.parse(strg_intlang);
            return new LanguageItem(lang);
        }
        catch (ParseException mcle) {
            return null;
        }
    }

    public CountryItem readCountry(Element element_xml) {
        try {
            Country country = Country.parse(element_xml.getAttribute("country"));
            return new CountryItem(country);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public NumberItem readNumber(Element element_xml) {
        String valString = element_xml.getAttribute("val");
        try {
            Decimal decimal = StringUtils.parseStrictDecimal(valString);
            return new NumberItem(decimal);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public GeopointItem readGeopoint(Element element_xml) {
        String latitudeString = element_xml.getAttribute("lat");
        String longitudeString = element_xml.getAttribute("lon");
        if (longitudeString.length() == 0) {
            longitudeString = element_xml.getAttribute("long");
        }
        try {
            Decimal latitude = StringUtils.parseStrictDecimal(latitudeString);
            Decimal longitude = StringUtils.parseStrictDecimal(longitudeString);
            return new GeopointItem(DegreDecimal.newInstance(latitude), DegreDecimal.newInstance(longitude));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public ParaItem readPara(Element element_xml) {
        ParaItem.Builder builder = new ParaItem.Builder();
        this.readContentList(builder, element_xml);
        return builder.toParaItem();
    }

    public AmountItem readAmount(Element element_xml) {
        String valString = element_xml.getAttribute("val");
        String curString = element_xml.getAttribute("cur");
        try {
            Decimal decimal = StringUtils.parseStrictDecimal(valString);
            ExtendedCurrency currency = ExtendedCurrency.parse(curString);
            return new AmountItem(decimal, currency);
        }
        catch (NumberFormatException | ParseException e) {
            return null;
        }
    }

    public DateItem readDate(Element element_xml) {
        FuzzyDate date;
        String type = element_xml.getAttribute("type");
        String a = element_xml.getAttribute("a");
        String s = element_xml.getAttribute("s");
        String t = element_xml.getAttribute("t");
        String m = element_xml.getAttribute("m");
        String j = element_xml.getAttribute("j");
        try {
            int annee = Integer.parseInt(a);
            if (type.equals("s")) {
                int semestre = Integer.parseInt(s);
                date = FuzzyDate.fromHalfYear(annee, semestre);
            } else if (type.equals("t")) {
                int trimestre = Integer.parseInt(t);
                date = FuzzyDate.fromQuarter(annee, trimestre);
            } else if (type.equals("m")) {
                int mois = Integer.parseInt(m);
                date = FuzzyDate.fromMonth(annee, mois);
            } else if (type.equals("j")) {
                int mois = Integer.parseInt(m);
                int jour = Integer.parseInt(j);
                date = FuzzyDate.fromDay(annee, mois, jour);
            } else {
                date = FuzzyDate.fromYear(annee);
            }
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return new DateItem(date);
    }

    public LinkItem readLink(Element element_xml) {
        String href = element_xml.getAttribute("href");
        String title = "";
        String comment = "";
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagname = element.getTagName();
            if (tagname.equals("title")) {
                title = XMLUtils.getData(element);
                continue;
            }
            if (!tagname.equals("comment")) continue;
            comment = XMLUtils.getData(element);
        }
        return new LinkItem(href, title, comment);
    }

    public ImageItem readImage(Element element_xml) {
        String src = element_xml.getAttribute("src");
        String alt = "";
        String title = "";
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagname = element.getTagName();
            if (tagname.equals("alt")) {
                alt = XMLUtils.getData(element);
                continue;
            }
            if (!tagname.equals("title")) continue;
            title = XMLUtils.getData(element);
        }
        return new ImageItem(src, alt, title);
    }

    public EmailItem readEmail(Element element_xml) {
        String strg;
        String addrSpec = element_xml.getAttribute("addr-spec");
        String realName = element_xml.getAttribute("real-name");
        if (realName.length() == 0 && (strg = XMLUtils.getData(element_xml)).length() > 0) {
            try {
                EmailCore c2 = EmailCoreUtils.parse(strg);
                realName = c2.getRealName();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            EmailCore emailCore = EmailCoreUtils.parse(addrSpec, realName);
            return new EmailItem(emailCore);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public Item readEntite(Element element_xml) {
        String nom = "";
        String localisation = "";
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element el = (Element)liste.item(i);
            String tagname = el.getTagName();
            if (tagname.equals("nom")) {
                nom = XMLUtils.getData(el);
                continue;
            }
            if (!tagname.equals("localisation")) continue;
            localisation = XMLUtils.getData(el);
        }
        return new Item(nom);
    }

    public Item readBiblio(Element element_xml) {
        String titre = "";
        String auteurs = "";
        String collection = "";
        String editeur = "";
        String ville = "";
        String pays = "";
        String annee = "";
        String nbrepages = "";
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element el = (Element)liste.item(i);
            String tagname = el.getTagName();
            if (tagname.equals("titre")) {
                titre = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("auteurs")) {
                auteurs = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("collection")) {
                collection = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("editeur")) {
                editeur = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("ville")) {
                ville = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("pays")) {
                pays = XMLUtils.getData(el);
                continue;
            }
            if (tagname.equals("annee")) {
                annee = XMLUtils.getData(el);
                continue;
            }
            if (!tagname.equals("nbrepages")) continue;
            nbrepages = XMLUtils.getData(el);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(titre);
        this.appendString(buf, auteurs);
        this.appendString(buf, collection);
        this.appendString(buf, editeur);
        this.appendString(buf, ville);
        this.appendString(buf, pays);
        this.appendString(buf, annee);
        this.appendString(buf, nbrepages);
        return new Item(buf.toString());
    }

    private void appendString(StringBuilder buf, String s) {
        if (s.length() > 0) {
            buf.append(", ");
            buf.append(s);
        }
    }

    public void readSection(Fiche fiche, Element element) {
        FieldKey fieldKey;
        String type = element.getAttribute("type");
        if (type.length() == 0) {
            return;
        }
        try {
            fieldKey = FieldKey.parse((short)3, type);
        }
        catch (ParseException pe) {
            return;
        }
        List<FicheBlock> list = this.readFicheBlockList(element);
        FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
        if (this.append) {
            fiche.appendSection(fieldKey, ficheBlocks);
        } else {
            fiche.setSection(fieldKey, ficheBlocks);
        }
    }

    public FicheBlock readFicheBlock(Element element) {
        String tagname = element.getTagName();
        if (tagname.equals("p")) {
            return this.readP(element);
        }
        if (tagname.equals("ul")) {
            return this.readUl(element);
        }
        if (tagname.equals("h")) {
            return this.readH(element);
        }
        if (tagname.equals("code")) {
            return this.readCode(element);
        }
        if (tagname.equals("table")) {
            return this.readTable(element);
        }
        if (tagname.equals("insert")) {
            return this.readInsert(element);
        }
        if (tagname.equals("div")) {
            return this.readDiv(element);
        }
        if (tagname.equals("cdatadiv")) {
            return this.readCdatadiv(element);
        }
        return null;
    }

    public P readP(Element element_xml) {
        short type = P.typeToShort(element_xml.getAttribute("type"));
        P p = new P(type);
        p.setSource(element_xml.getAttribute("source"));
        this.readParagraphBlock(p, element_xml);
        return p;
    }

    public H readH(Element element_xml) {
        int level = 1;
        try {
            level = Integer.parseInt(element_xml.getAttribute("level"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        H h = new H(level);
        this.readParagraphBlock(h, element_xml);
        return h;
    }

    public Ul readUl(Element element_xml) {
        Ul ul = null;
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Li li;
            Element el;
            String tagname;
            if (liste.item(j).getNodeType() != 1 || !(tagname = (el = (Element)liste.item(j)).getTagName()).equals("li") || (li = this.readLi(el)) == null) continue;
            if (ul == null) {
                ul = new Ul(li);
                continue;
            }
            ul.add(li);
        }
        if (ul != null) {
            this.readOldAtt(ul, element_xml);
        }
        return ul;
    }

    public Li readLi(Element element_xml) {
        Li li;
        List<FicheBlock> list = this.readFicheBlockList(element_xml);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        FicheBlock firstFicheBlock = list.get(0);
        if (firstFicheBlock instanceof P) {
            li = new Li((P)firstFicheBlock);
        } else {
            li = new Li(new P());
            if (li.isValidFicheBlock(firstFicheBlock)) {
                li.add(firstFicheBlock);
            }
        }
        this.readOldAtt(li, element_xml);
        for (int i = 1; i < size; ++i) {
            li.add(list.get(i));
        }
        return li;
    }

    public Code readCode(Element element_xml) {
        short type = Code.typeToShort(element_xml.getAttribute("type"));
        Code code = new Code(type);
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            String tagname;
            if (liste.item(j).getNodeType() != 1 || !(tagname = (el = (Element)liste.item(j)).getTagName()).equals("ln")) continue;
            code.add(this.readLn(el));
        }
        this.readZoneBlock(code, element_xml);
        return code;
    }

    public Table readTable(Element element_xml) {
        Table table = new Table();
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            if (liste.item(j).getNodeType() != 1) continue;
            Element el = (Element)liste.item(j);
            String tagname = el.getTagName();
            if (tagname.equals("tr")) {
                table.add(this.readTr(el));
                continue;
            }
            if (!tagname.equals("caption")) continue;
            String caption = XMLUtils.getData(el);
            table.getLegendeBuilder().addText(caption);
        }
        this.readZoneBlock(table, element_xml);
        return table;
    }

    public Tr readTr(Element element_xml) {
        Tr tr = new Tr();
        this.readOldAtt(tr, element_xml);
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            String tagname;
            if (liste.item(j).getNodeType() != 1 || !(tagname = (el = (Element)liste.item(j)).getTagName()).equals("td")) continue;
            tr.add(this.readTd(el));
        }
        return tr;
    }

    public Ln readLn(Element element_xml) {
        int indentation = 0;
        try {
            indentation = Integer.parseInt(element_xml.getAttribute("indent"));
            if (indentation < 0) {
                indentation = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Ln ln = new Ln(XMLUtils.getData(element_xml, false), indentation);
        this.readOldAtt(ln, element_xml);
        return ln;
    }

    public Td readTd(Element element_xml) {
        String typeString = element_xml.getAttribute("type");
        Td td = new Td(Td.typeToShort(typeString));
        this.readParagraphBlock(td, element_xml);
        return td;
    }

    public Insert readInsert(Element element_xml) {
        Insert insert;
        try {
            short type = Insert.typeToShort(element_xml.getAttribute("type"));
            insert = new Insert(type);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        insert.setSrc(element_xml.getAttribute("src"));
        insert.setRef(element_xml.getAttribute("ref"));
        String creditString = element_xml.getAttribute("credit");
        if (creditString.length() > 0) {
            insert.getCreditBuilder().addText(creditString);
        }
        insert.setPosition(Insert.positionToString(element_xml.getAttribute("position")));
        try {
            int width = Integer.parseInt(element_xml.getAttribute("width"));
            insert.setWidth(width);
        }
        catch (NumberFormatException width) {
            // empty catch block
        }
        try {
            int height = Integer.parseInt(element_xml.getAttribute("height"));
            insert.setHeight(height);
        }
        catch (NumberFormatException height) {
            // empty catch block
        }
        String albumName = element_xml.getAttribute("album");
        if (albumName.length() > 0) {
            try {
                SubsetKey albumKey = SubsetKey.parse((short)5, albumName);
                String idString = element_xml.getAttribute("idalbum");
                if (idString.length() > 0) {
                    try {
                        int illustrationid = Integer.parseInt(idString);
                        String albumDimName = element_xml.getAttribute("albumdim");
                        insert.setSubsetItem(albumKey, illustrationid, albumDimName);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.readZoneBlock(insert, element_xml);
        return insert;
    }

    public Div readDiv(Element element_xml) {
        Div div = new Div();
        this.readZoneBlock(div, element_xml);
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            String tagname;
            if (liste.item(j).getNodeType() != 1 || !(tagname = (el = (Element)liste.item(j)).getTagName()).equals("fbl")) continue;
            List<FicheBlock> list = this.readFicheBlockList(el);
            for (FicheBlock ficheBlock : list) {
                div.add(ficheBlock);
            }
        }
        return div;
    }

    public Cdatadiv readCdatadiv(Element element_xml) {
        Cdatadiv cdatadiv = new Cdatadiv();
        this.readZoneBlock(cdatadiv, element_xml);
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            String tagname;
            if (liste.item(j).getNodeType() != 1 || !(tagname = (el = (Element)liste.item(j)).getTagName()).equals("cdata")) continue;
            String cdata = XMLUtils.getRawData(el);
            cdatadiv.setCdata(this.htmlCleaner.cleanHtml(cdata));
            break;
        }
        return cdatadiv;
    }

    private void readZoneBlock(ZoneBlock zoneBlock, Element element_xml) {
        this.readOldAtt(zoneBlock, element_xml);
        NodeList liste = element_xml.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            if (liste.item(j).getNodeType() != 1) continue;
            Element el = (Element)liste.item(j);
            String tagname = el.getTagName();
            if (tagname.equals("numero")) {
                this.readContentList(zoneBlock.getNumeroBuilder(), el);
                continue;
            }
            if (!tagname.equals("legende")) break;
            this.readContentList(zoneBlock.getLegendeBuilder(), el);
        }
    }

    public S readS(Element element_xml) {
        int type;
        String typeString = element_xml.getAttribute("type");
        String subType = null;
        if (typeString.equals("xml")) {
            type = 10;
            subType = "XML";
        } else if (typeString.equals("cmd")) {
            type = 10;
            subType = "CMD";
        } else if (typeString.equals("ui")) {
            type = 11;
            subType = "UI";
        } else {
            try {
                type = S.typeToShort(typeString);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        S s = new S((short)type);
        s.setValue(XMLUtils.getData(element_xml, false));
        String ref = element_xml.getAttribute("ref");
        if (type == 7) {
            String src = element_xml.getAttribute("src");
            s.setRef(src);
            if (ref.length() > 0) {
                s.putAtt("href", ref);
            }
        } else {
            s.setRef(ref);
        }
        if (subType == null) {
            subType = element_xml.getAttribute("subtype");
        }
        this.readSOldAtt(s, element_xml, subType);
        return s;
    }

    private void readOldAtt(AttConsumer attConsumer, Element element_xml) {
        String colspan;
        String rowspan;
        String id;
        String className = element_xml.getAttribute("class");
        if (className.length() > 0) {
            attConsumer.putAtt("class", className);
        }
        if ((id = element_xml.getAttribute("htmlid")).length() > 0) {
            attConsumer.putAtt("id", id);
        }
        if ((rowspan = element_xml.getAttribute("rowspan")).length() > 0) {
            attConsumer.putAtt("rowspan", rowspan);
        }
        if ((colspan = element_xml.getAttribute("colspan")).length() > 0) {
            attConsumer.putAtt("colspan", colspan);
        }
    }

    private void readSOldAtt(AttConsumer attConsumer, Element element_xml, String subType) {
        String lang;
        String title;
        String id;
        String className;
        StringBuilder classBuf = new StringBuilder();
        if (subType != null) {
            classBuf.append(subType);
        }
        if ((className = element_xml.getAttribute("class")).length() > 0) {
            if (classBuf.length() > 0) {
                classBuf.append(' ');
            }
            classBuf.append(className);
        }
        if (classBuf.length() > 0) {
            attConsumer.putAtt("class", classBuf.toString());
        }
        if ((id = element_xml.getAttribute("htmlid")).length() > 0) {
            attConsumer.putAtt("id", id);
        }
        if ((title = element_xml.getAttribute("title")).length() > 0) {
            attConsumer.putAtt("title", title);
        }
        if ((lang = element_xml.getAttribute("lang")).length() > 0) {
            attConsumer.putAtt("hreflang", lang);
        }
    }

    private void readParagraphBlock(ParagraphBlock pb, Element element_xml) {
        String id;
        String className = element_xml.getAttribute("class");
        if (className.length() > 0) {
            pb.putAtt("class", className);
        }
        if ((id = element_xml.getAttribute("htmlid")).length() > 0) {
            pb.putAtt("id", id);
        }
        this.readContentList(pb, element_xml);
    }

    private void readContentList(TextContentBuilder pb, Element element_xml) {
        NodeList list = element_xml.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            short type = list.item(i).getNodeType();
            if (type == 3) {
                String data = ((Text)list.item(i)).getData();
                if ((data = XMLUtils.cleanString(data, false)).length() <= 0) continue;
                pb.addText(data);
                continue;
            }
            if (type != 1 || !(element = (Element)list.item(i)).getTagName().equals("s")) continue;
            S span = this.readS(element);
            if (span != null) {
                pb.addS(span);
                continue;
            }
            String data = XMLUtils.getData(element, false);
            if (data.length() <= 0) continue;
            pb.addText(data);
        }
    }

    private FicheItems readFicheItems(Element element) {
        ArrayList<FicheItem> list = new ArrayList<FicheItem>();
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            FicheItem ficheItem;
            if (liste.item(j).getNodeType() != 1 || (ficheItem = this.readFicheItem(el = (Element)liste.item(j))) == null) continue;
            try {
                list.add(ficheItem);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return FicheUtils.toFicheItems(list);
    }

    public List<FicheBlock> readFicheBlockList(Element element) {
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        NodeList liste = element.getChildNodes();
        for (int j = 0; j < liste.getLength(); ++j) {
            Element el;
            FicheBlock ficheBlock;
            if (liste.item(j).getNodeType() != 1 || (ficheBlock = this.readFicheBlock(el = (Element)liste.item(j))) == null) continue;
            list.add(ficheBlock);
        }
        return list;
    }

    private class CorpsdeficheConsumer
    implements Consumer<Element> {
        private CorpsdeficheConsumer() {
        }

        @Override
        public void accept(Element element) {
            this.readCorpsdeficheElement(element);
        }

        private boolean readCorpsdeficheElement(Element el) {
            String tagname = el.getTagName();
            if (tagname.equals("texte")) {
                FieldKey fieldKey = FieldKey.build((short)3, "texte");
                List<FicheBlock> list = OldFicheDOMReader.this.readFicheBlockList(el);
                FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
                if (OldFicheDOMReader.this.append) {
                    OldFicheDOMReader.this.currentFiche.appendSection(fieldKey, ficheBlocks);
                } else {
                    OldFicheDOMReader.this.currentFiche.setSection(fieldKey, ficheBlocks);
                }
                return true;
            }
            if (tagname.equals("section") || tagname.equals("annexe")) {
                OldFicheDOMReader.this.readSection(OldFicheDOMReader.this.currentFiche, el);
                return true;
            }
            return false;
        }
    }

    private class EnteteConsumer
    implements Consumer<Element> {
        private EnteteConsumer() {
        }

        @Override
        public void accept(Element element) {
            this.readEnteteElement(element);
        }

        private boolean readEnteteElement(Element el) {
            switch (el.getTagName()) {
                case "title": 
                case "titre": {
                    OldFicheDOMReader.this.currentFiche.setTitle(XMLUtils.getData(el));
                    return true;
                }
                case "subtitle": 
                case "soustitre": {
                    OldFicheDOMReader.this.currentFiche.setSubtitle(OldFicheDOMReader.this.readPara(el));
                    return true;
                }
                case "prop": 
                case "propriete": {
                    OldFicheDOMReader.this.readProp(OldFicheDOMReader.this.currentFiche, el);
                    return true;
                }
                case "info": 
                case "information": {
                    OldFicheDOMReader.this.readInfo(OldFicheDOMReader.this.currentFiche, el);
                    return true;
                }
                case "owners": 
                case "redacteurs": {
                    OldFicheDOMReader.this.readOwners(OldFicheDOMReader.this.currentFiche, el);
                    return true;
                }
            }
            return false;
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            boolean isEnteteElement;
            String tagName = element.getTagName();
            if (tagName.equals("entete")) {
                DOMUtils.readChildren(element, OldFicheDOMReader.this.enteteConsumer);
            } else if (tagName.equals("corpsdefiche")) {
                DOMUtils.readChildren(element, OldFicheDOMReader.this.corpsdeficheConsumer);
            } else if (tagName.equals("source")) {
                DOMUtils.readChildren(element, OldFicheDOMReader.this.enteteConsumer);
            } else if (OldFicheDOMReader.this.allowFlat && !(isEnteteElement = OldFicheDOMReader.this.enteteConsumer.readEnteteElement(element))) {
                OldFicheDOMReader.this.corpsdeficheConsumer.readCorpsdeficheElement(element);
            }
        }
    }
}

