/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.File;
import net.mapeadores.util.annotation.Nullable;

public interface StorageDirectory {
    public File getDataDir();

    @Nullable
    public File getBackupDir();

    default public boolean isWithBackup() {
        return this.getBackupDir() != null;
    }

    default public File getDataFile(String path) {
        return new File(this.getDataDir(), path);
    }

    default public File getDataDir(String path) {
        File dir = new File(this.getDataDir(), path);
        if (dir.exists() && !dir.isDirectory()) {
            throw new BdfStorageException(dir.getPath() + " is not a directory");
        }
        return dir;
    }

    default public StorageFile getStorageFile(String path) {
        File file = new File(this.getDataDir(), path);
        File backupFile = null;
        if (this.isWithBackup()) {
            backupFile = new File(this.getBackupDir(), path);
        }
        return new StorageFile(path, file, backupFile);
    }
}

