/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.jsonproducers.corpus.FicheFormJsonProperty;
import fr.exemole.bdfserver.jsonproducers.corpus.FicheJsonProperty;
import fr.exemole.bdfserver.jsonproducers.corpus.FichesJsonProperty;
import fr.exemole.bdfserver.jsonproducers.corpus.JunctionHistoryArrayProperty;
import fr.exemole.bdfserver.jsonproducers.corpus.LastRevisionsProperty;
import fr.exemole.bdfserver.jsonproducers.corpus.UiJsonProperty;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.ResultJsonProducer;
import fr.exemole.bdfserver.tools.interaction.PropertiesParam;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.ArrayList;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.fichotheque.utils.selection.FicheSelectorBuilder;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public final class CorpusJsonProducerFactory {
    private CorpusJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(OutputParameters parameters) throws ErrorMessageException {
        String json = parameters.getOutput();
        ResultJsonProducer jsonProducer = new ResultJsonProducer(parameters);
        JsonProperty jsonProperty = CorpusJsonProducerFactory.getJsonProperty(parameters, json);
        if (jsonProperty == null) {
            return null;
        }
        jsonProducer.add(jsonProperty);
        return jsonProducer;
    }

    public static JsonProperty getJsonProperty(OutputParameters parameters, String name) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init(parameters);
        BdfServer bdfServer = parameters.getBdfServer();
        Lang lang = parameters.getWorkingLang();
        switch (name) {
            case "ui": {
                Corpus corpus = requestHandler.getCorpus();
                return new UiJsonProperty(corpus, lang, bdfServer.getUiManager().getMainUiComponents(corpus));
            }
            case "removedlist": {
                Corpus corpus = requestHandler.getCorpus();
                return new LastRevisionsProperty(bdfServer, corpus.getRemovedFicheHistoryList());
            }
            case "junctionhistorylist": {
                Corpus corpus = requestHandler.getCorpus();
                int id = requestHandler.getMandatoryId();
                Thesaurus thesaurus = requestHandler.getThesaurus();
                return new JunctionHistoryArrayProperty(corpus.getJunctionHistoryList(id, thesaurus.getSubsetKey()));
            }
            case "fiches": {
                Fiches fiches = CorpusJsonProducerFactory.getFiches(requestHandler);
                return new FichesJsonProperty(parameters.getPermissionSummary(), fiches, BdfInstructionUtils.getCellConverter(parameters), parameters.getWorkingLang());
            }
            case "fiche": {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                requestHandler.getPermissionChecker().checkRead(ficheMeta);
                return CorpusJsonProducerFactory.resolveJsonProperty(parameters, ficheMeta);
            }
        }
        return null;
    }

    private static Fiches getFiches(OutputRequestHandler requestHandler) throws ErrorMessageException {
        SelectionContext selectionContext = BdfServerUtils.initSelectionContextBuilder(requestHandler).setSubsetAccessPredicate(requestHandler.getPermissionSummary().getSubsetAccessPredicate()).setFichePredicate(PermissionUtils.getFichePredicate(requestHandler.getPermissionSummary())).toSelectionContext();
        FicheSelector ficheSelector = requestHandler.populate(FicheSelectorBuilder.init(selectionContext)).toFicheSelector();
        return FichesBuilder.init(requestHandler.getComparator(selectionContext.getWorkingLang())).initSubsetKeyOrder(TreeUtils.getCorpusKeyList(requestHandler.getBdfServer())).populate(ficheSelector).toFiches();
    }

    private static JsonProperty resolveJsonProperty(OutputParameters parameters, FicheMeta ficheMeta) throws ErrorMessageException {
        RequestMap requestMap = parameters.getRequestMap();
        PropertiesParam propertiesParam = PropertiesParam.fromRequest(requestMap);
        CellConverter cellConverter = null;
        if (propertiesParam.isSpecial()) {
            switch (propertiesParam.getName()) {
                case "form": {
                    return CorpusJsonProducerFactory.resolveFormSpecialJsonProperty(parameters, ficheMeta);
                }
            }
        }
        cellConverter = BdfInstructionUtils.getCellConverter(parameters);
        return new FicheJsonProperty(parameters.getPermissionSummary(), ficheMeta, cellConverter);
    }

    private static JsonProperty resolveFormSpecialJsonProperty(OutputParameters parameters, FicheMeta ficheMeta) throws ErrorMessageException {
        FichePointeur fichePointeur = PointeurFactory.newFichePointeur(ficheMeta.getCorpus(), true).setCurrentFicheMeta(ficheMeta);
        FicheFormParameters ficheFormParameters = FicheFormUtils.initFicheFormParametersBuilder(parameters).toFicheFormParameters();
        FormEntryProvider formEntryProvider = FormEntryProviderFactory.newInstance(ficheFormParameters);
        ArrayList<FormEntry> formEntryList = new ArrayList<FormEntry>();
        for (UiComponent uiComponent : parameters.getBdfServer().getUiManager().getMainUiComponents(ficheMeta.getCorpus()).getUiComponentList()) {
            FormEntry formEntry;
            if (uiComponent instanceof FieldUi) {
                formEntry = formEntryProvider.getFormEntry(fichePointeur, (FieldUi)uiComponent);
                if (formEntry == null) continue;
                formEntryList.add(formEntry);
                continue;
            }
            if (!(uiComponent instanceof IncludeUi) || (formEntry = formEntryProvider.getFormEntry(fichePointeur, (IncludeUi)uiComponent)) == null) continue;
            formEntryList.add(formEntry);
        }
        return new FicheFormJsonProperty(parameters.getPermissionSummary(), ficheMeta, formEntryList, parameters.getWorkingLang());
    }
}

