/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.BdfExtensionReference;
import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.html.consumers.Choices;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.LangRows;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.Message;

public final class ConfigurationCommandBoxUtils {
    private static final Litteral ICON = new Litteral("icon");
    private static final Litteral TOUCH = new Litteral("apple-touch-icon");
    private static final Litteral SHORTCUT = new Litteral("shortcut icon");

    private ConfigurationCommandBoxUtils() {
    }

    public static boolean printCustomIconUploadBox(HtmlPrinter hp, CommandBox commandBox) {
        commandBox = commandBox.derive("LogoUpload", "_ CNF-09").actionCssClass("action-Save").submitLocKey("_ submit.administration.resourceupload");
        hp.__start(commandBox).__(Grid.START).__(Grid.fileInputRow("_ label.configuration.customiconfile", hp.name("file").size("75").classes("global-FileInput"))).__(Grid.textInputRow("_ label.configuration.sizes", hp.name("sizes").size("20").populate(InputPattern.SIZES))).__(Grid.choiceSetRow((Object)"_ label.configuration.rel", () -> hp.__(Grid.radioCell(ICON, hp.name("rel").value("icon").checked(true))).__(Grid.radioCell(TOUCH, hp.name("rel").value("touch"))).__(Grid.radioCell(SHORTCUT, hp.name("rel").value("shortcut"))))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printGroupCreationBox(HtmlPrinter hp, CommandBox commandBox, Langs langs) {
        commandBox = commandBox.derive("GroupCreation", "_ CNF-10").actionCssClass("action-New").submitLocKey("_ submit.configuration.groupcreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.configuration.newgroupname", hp.name("name").size("30"))).__(Grid.END).DL("global-DL").DT().__localize("_ label.configuration.grouptitle")._DT().DD().__(Grid.START).__(LangRows.init("title/", null, langs).cols(30)).__(Grid.END)._DD()._DL().__(Grid.START).__(Grid.textAreaBlockRow("_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printGroupChangeBox(HtmlPrinter hp, CommandBox commandBox, GroupDef groupDef, Langs langs) {
        commandBox = commandBox.derive("GroupChange", "_ CNF-11").hidden("name", groupDef.getName()).__(Flag.UPDATE_COLLECTIONS).__(Flag.UPDATE_CORPUS_TREE).submitLocKey("_ submit.configuration.groupchange");
        hp.__start(commandBox).DL("global-DL").DT().__localize("_ label.configuration.grouptitle")._DT().DD().__(Grid.START).__(LangRows.init("title/", groupDef.getTitleLabels(), langs).cols(30)).__(Grid.END)._DD()._DL().__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), () -> hp.__escape(AttributeParser.toString(groupDef.getAttributes()), true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printGroupRemoveBox(HtmlPrinter hp, CommandBox commandBox, GroupDef groupDef) {
        commandBox = commandBox.derive("GroupRemove", "_ CNF-12").hidden("name", groupDef.getName()).actionCssClass("action-Delete").submitLocKey("_ submit.configuration.groupremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printExtensionActivationBox(HtmlPrinter hp, CommandBox commandBox, ExtensionManager extensionManager) {
        commandBox = commandBox.derive("ExtensionActivation", "_ CNF-18").submitLocKey("_ submit.configuration.extensionactivation");
        hp.__start(commandBox).__(Choices.SPACED_LIST, () -> {
            for (BdfExtensionReference reference : extensionManager.getBdfExtensionReferenceList()) {
                String registrationName = reference.getRegistrationName();
                Message titleMessage = reference.getTitleMessage();
                hp.__(Choices.checkboxLi(hp.name("activation").value(registrationName).checked(reference.isActive()), () -> {
                    hp.__escape('[').__escape(registrationName).__escape(']');
                    if (titleMessage != null) {
                        hp.__dash().__localize(titleMessage);
                    }
                }));
            }
        }).__end(commandBox);
        return true;
    }
}

