/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MotcleMergeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MotcleMerge";
    public static final String COMMANDKEY = "_ THS-18";
    public static String MERGETHESAURUS_PARAMNAME = "mergethesaurus";
    public static String MERGEMOTCLE_PARAMNAME = "mergemotcle";
    private Motcle motcle;
    private Motcle mergeMotcle;

    public MotcleMergeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Thesaurus mergeThesaurus = this.mergeMotcle.getThesaurus();
        Lang workingLang = this.bdfUser.getWorkingLang();
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            try {
                Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(mergeThesaurus);
                ThesaurusTools.merge(session.getFichothequeEditor(), this.motcle, this.mergeMotcle, langs);
            }
            catch (ParentRecursivityException pre) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.bdfUser.putParameter("bdf.thesaurus.merge_last", mergeThesaurus.getSubsetKey());
        this.putResultObject("obj.thesaurus", mergeThesaurus);
        this.putResultObject("obj.motcle", this.mergeMotcle);
        String messageKey = mergeThesaurus.equals(this.motcle.getThesaurus()) ? "_ done.thesaurus.motclemerge_samethesaurus" : "_ done.thesaurus.motclemerge_otherthesaurus";
        this.setDone(messageKey, ThesaurusUtils.getMotcleTitle(this.motcle, workingLang, true, false), ThesaurusUtils.getMotcleTitle(this.mergeMotcle, workingLang, true, false));
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        String mergeThesaurusName = this.getMandatory(MERGETHESAURUS_PARAMNAME);
        Thesaurus mergeThesaurus = this.fichotheque.getThesaurus(mergeThesaurusName);
        if (mergeThesaurus == null) {
            throw BdfErrors.error("_ error.unknown.thesaurus", mergeThesaurusName);
        }
        this.getPermissionChecker().checkSubsetAdmin(this.motcle.getThesaurus()).checkSubsetAccess(mergeThesaurus);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_merge");
        }
        String idMergeString = this.getMandatory(MERGEMOTCLE_PARAMNAME);
        try {
            this.mergeMotcle = mergeThesaurus.getMotcleByIdString(idMergeString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.mergeMotcle == null) {
            throw BdfErrors.error("_ error.unknown.mergemotcle", idMergeString);
        }
        if (this.mergeMotcle.isDescendantOf(this.motcle)) {
            throw BdfErrors.error("_ error.unsupported.recursivemerge", idMergeString);
        }
    }
}

