/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.PasswordManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurPasswordCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurPassword";
    public static final String COMMANDKEY = "_ USR-03";
    public static final String PASSWORD1_PARAMNAME = "password1";
    public static final String PASSWORD2_PARAMNAME = "password2";
    private Redacteur redacteur;
    private String password;

    public RedacteurPasswordCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        PasswordManager passwordManager = this.bdfServer.getPasswordManager();
        passwordManager.setPassword(this.redacteur.getGlobalId(), this.password);
        this.setDone("_ done.sphere.passwordchange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String mdp2;
        String mdp1;
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.getPermissionChecker().checkSphereSupervisor(this.redacteur.getSubsetName());
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, this.redacteur);
        if (!isSame || !this.bdfServer.getPolicyManager().getUserAllow().isDataChangeAllowed()) {
            this.checkSubsetAdmin(this.redacteur.getSphere());
        }
        if (!(mdp1 = this.getMandatory(PASSWORD1_PARAMNAME)).equals(mdp2 = this.getMandatory(PASSWORD2_PARAMNAME))) {
            throw BdfErrors.error("_ error.wrong.password_different");
        }
        this.password = mdp1;
        if (this.password.length() == 0) {
            throw BdfErrors.error("_ error.empty.password");
        }
        if (this.password.length() < 4) {
            throw BdfErrors.error("_ error.wrong.password_tooshort");
        }
    }
}

