/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurCreation";
    public static final String COMMANDKEY = "_ SPH-04";
    public static final String NEWLOGIN_PARAMNAME = "newlogin";
    private String newLogin;
    private Sphere sphere;

    public RedacteurCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Redacteur redacteur;
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            SphereEditor sphereEditor = session.getFichothequeEditor().getSphereEditor(this.sphere.getSubsetKey());
            try {
                redacteur = sphereEditor.createRedacteur(-1, this.newLogin);
            }
            catch (ExistingIdException iee) {
                throw new ShouldNotOccurException("test before ExistingIdException");
            }
            catch (ParseException pe) {
                throw new ShouldNotOccurException("test before ParseException");
            }
        }
        this.putResultObject("obj.sphere", redacteur.getSphere());
        this.putResultObject("obj.redacteur", redacteur);
        this.setDone("_ done.sphere.redacteurcreation", this.newLogin);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.sphere = this.requestHandler.getMandatorySphere();
        this.getPermissionChecker().checkSphereSupervisor(this.sphere.getSubsetName());
        String param_new = this.getMandatory(NEWLOGIN_PARAMNAME).trim();
        if (param_new.isEmpty()) {
            throw BdfErrors.error("_ error.empty.login", param_new);
        }
        if (!SphereUtils.testLogin(param_new)) {
            throw BdfErrors.error("_ error.wrong.login", param_new);
        }
        if (this.sphere.getRedacteurByLogin(param_new) != null) {
            throw BdfErrors.error("_ error.existing.login", param_new);
        }
        this.newLogin = param_new;
    }
}

